/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.resteasy.ResteasyEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResteasyProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ResteasyProducer.class);
    ResteasyEndpoint endpoint;

    public ResteasyProducer(ResteasyEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        ResteasyEndpoint endpoint = (ResteasyEndpoint)this.getEndpoint();
        LOG.debug("Uri pattern from endpoint: {}", (Object)endpoint.getUriPattern());
        String resourceUri = ResteasyProducer.buildUri(endpoint, exchange);
        LOG.debug("Final URI: {} ", (Object)resourceUri);
        endpoint.getRestEasyHttpBindingRef().setHeaderFilterStrategy(endpoint.getHeaderFilterStrategy());
        Map<String, String> parameters = ResteasyProducer.getParameters(exchange, endpoint);
        if (endpoint.getProxyClientClass() != null) {
            if (endpoint.getProxyClientClass().isEmpty()) {
                throw new IllegalArgumentException("Uri option proxyClientClass cannot be empty! Full class name must be specified.");
            }
            endpoint.getRestEasyHttpBindingRef().populateProxyResteasyRequestAndExecute(resourceUri, exchange, parameters);
        } else {
            Response response = endpoint.getRestEasyHttpBindingRef().populateResteasyRequestFromExchangeAndExecute(resourceUri, exchange, parameters);
            endpoint.getRestEasyHttpBindingRef().populateExchangeFromResteasyResponse(exchange, response);
            response.close();
        }
    }

    private static String buildUri(ResteasyEndpoint endpoint, Exchange exchange) throws CamelExchangeException {
        String uri = endpoint.getPort() == 0 ? endpoint.getProtocol() + "://" + endpoint.getHost() + endpoint.getUriPattern() : endpoint.getProtocol() + "://" + endpoint.getHost() + ":" + endpoint.getPort() + endpoint.getUriPattern();
        String query = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (query != null) {
            LOG.debug("Adding query: {} to uri: {}", (Object)query, (Object)uri);
            uri = ResteasyProducer.addQueryToUri(uri, query);
        }
        LOG.debug("Using uri: {}", (Object)uri);
        return uri;
    }

    protected static String addQueryToUri(String uri, String query) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        StringBuilder answer = new StringBuilder();
        int index = uri.indexOf(63);
        if (index < 0) {
            answer.append(uri);
            answer.append("?");
            answer.append(query);
        } else {
            answer.append(uri.substring(0, index));
            answer.append("?");
            answer.append(query);
            String remaining = uri.substring(index + 1);
            if (remaining.length() > 0) {
                answer.append("&");
                answer.append(remaining);
            }
        }
        return answer.toString();
    }

    protected static Map<String, String> getParameters(Exchange exchange, ResteasyEndpoint endpoint) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String method = endpoint.getResteasyMethod();
        String methodHeader = (String)exchange.getIn().getHeader("CamelResteasyHttpMethod", String.class);
        if (methodHeader != null && !method.equalsIgnoreCase(methodHeader)) {
            method = methodHeader;
        }
        parameters.put("method", method);
        String proxyClassName = endpoint.getProxyClientClass();
        parameters.put("proxyClassName", proxyClassName);
        String proxyMethodName = endpoint.getProxyMethod();
        String proxyMethodNameHeader = (String)exchange.getIn().getHeader("CamelResteasyProxyMethod", String.class);
        if (proxyMethodNameHeader != null && !proxyMethodName.equalsIgnoreCase(proxyMethodNameHeader)) {
            proxyMethodName = proxyMethodNameHeader;
        }
        parameters.put("proxyMethodName", proxyMethodName);
        String usernameHeader = (String)exchange.getIn().getHeader("CamelResteasyLogin", String.class);
        String passwordHeader = (String)exchange.getIn().getHeader("CamelResteasyPassword", String.class);
        String username = endpoint.getUsername();
        String password = endpoint.getPassword();
        if (usernameHeader != null && !username.equals(usernameHeader)) {
            username = usernameHeader;
        }
        if (passwordHeader != null && !password.equals(passwordHeader)) {
            password = passwordHeader;
        }
        parameters.put("username", username);
        parameters.put("password", password);
        return parameters;
    }
}

