/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.resteasy.ResteasyHttpBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.BasicAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResteasyHttpBinding
implements ResteasyHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResteasyHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    @Override
    public Response populateResteasyRequestFromExchangeAndExecute(String uri, Exchange exchange, Map<String, String> parameters) {
        String method;
        Client client = ClientBuilder.newBuilder().build();
        String body = (String)exchange.getIn().getBody(String.class);
        LOG.debug("Body in producer: {}", (Object)body);
        String mediaType = (String)exchange.getIn().getHeader("Content-Type", String.class);
        WebTarget target = client.target(uri);
        LOG.debug("Populate Resteasy request from exchange body: {} using media type {}", (Object)body, (Object)mediaType);
        Invocation.Builder builder = mediaType != null ? target.request(new String[]{mediaType}) : target.request();
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, value, exchange)) continue;
            builder.header(key, value);
            LOG.debug("Populate Resteasy request from exchange header: {} value: {}", (Object)key, value);
        }
        if (parameters.get("basicAuth") != null && Boolean.TRUE.equals(ObjectHelper.cast(Boolean.class, (Object)parameters.get("basicAuth"))) && parameters.get("username") != null && parameters.get("password") != null) {
            target.register((Object)new BasicAuthentication(parameters.get("username"), parameters.get("password")));
            LOG.debug("Basic authentication was applied");
        }
        if ((method = parameters.get("method")).equals("GET")) {
            return builder.get();
        }
        if (method.equals("POST")) {
            return builder.post(Entity.entity((Object)body, (String)mediaType));
        }
        if (method.equals("PUT")) {
            return builder.put(Entity.entity((Object)body, (String)mediaType));
        }
        if (method.equals("DELETE")) {
            return builder.delete();
        }
        if (method.equals("OPTIONS")) {
            return builder.options();
        }
        if (method.equals("TRACE")) {
            return builder.trace();
        }
        if (method.equals("HEAD")) {
            return builder.head();
        }
        throw new IllegalArgumentException("Method '" + method + "' is not supported method");
    }

    @Override
    public void populateProxyResteasyRequestAndExecute(String uri, Exchange exchange, Map<String, String> parameters) {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(uri);
        if (parameters.get("basicAuth") != null && Boolean.TRUE.equals(ObjectHelper.cast(Boolean.class, (Object)parameters.get("basicAuth"))) && parameters.get("username") != null && parameters.get("password") != null) {
            target.register((Object)new BasicAuthentication(parameters.get("username"), parameters.get("password")));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Basic authentication was applied");
            }
        }
        Object object = null;
        try {
            Class<?> realClazz = Class.forName(parameters.get("proxyClassName"));
            Object simple = ((ResteasyWebTarget)ObjectHelper.cast(ResteasyWebTarget.class, (Object)target)).proxy(realClazz);
            ArrayList headerParams = (ArrayList)exchange.getIn().getHeader("CamelResteasyProxyMethodArgs", ArrayList.class);
            if (headerParams != null) {
                Object[] args = new Object[headerParams.size()];
                Class[] paramsClasses = new Class[headerParams.size()];
                for (int i = 0; i < headerParams.size(); ++i) {
                    paramsClasses[i] = headerParams.get(i).getClass();
                    args[i] = headerParams.get(i);
                }
                Method m = simple.getClass().getMethod(parameters.get("proxyMethodName"), paramsClasses);
                object = m.invoke(simple, args);
            } else {
                Method m = simple.getClass().getMethod(parameters.get("proxyMethodName"), new Class[0]);
                object = m.invoke(simple, new Object[0]);
            }
            if (object instanceof Response) {
                this.populateExchangeFromResteasyResponse(exchange, (Response)object);
                ((Response)object).close();
            } else {
                exchange.getMessage().setBody(object);
                MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getMessage(), (boolean)false);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            exchange.getMessage().getHeaders().put("CamelResteasyProxyProducerException", e);
            exchange.getMessage().setBody((Object)e);
            LOG.error("Camel RESTEasy proxy exception: {}", (Throwable)e);
        }
    }

    @Override
    public void populateExchangeFromResteasyResponse(Exchange exchange, Response response) {
        int responseCode = response.getStatus();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelHttpResponseCode", responseCode);
        for (String key : response.getHeaders().keySet()) {
            Object value = response.getHeaders().get((Object)key);
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(key, value, exchange)) continue;
            headers.put(key, value);
            LOG.debug("Populate Camel exchange from response: {} value: {}", (Object)key, value);
        }
        headers.put("CamelResteasyResponse", response);
        exchange.getMessage().setHeaders(headers);
        LOG.debug("Headers from exchange.getIn() : {}", (Object)exchange.getIn().getHeaders().toString());
        LOG.debug("Headers from exchange.getOut() before copying : {}", (Object)exchange.getMessage().getHeaders().toString());
        LOG.debug("Header from response : {}", (Object)response.getHeaders().toString());
        if (response.hasEntity()) {
            exchange.getMessage().setBody(response.readEntity(String.class));
        } else {
            exchange.getMessage().setBody((Object)response.getStatusInfo());
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getMessage(), (boolean)false);
    }
}

