/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;

public class MiloClientProducer
extends DefaultAsyncProducer {
    private final MiloClientConnection connection;
    private final ExpandedNodeId nodeId;
    private final ExpandedNodeId methodId;
    private final boolean defaultAwaitWrites;

    public MiloClientProducer(MiloClientEndpoint endpoint, MiloClientConnection connection, boolean defaultAwaitWrites) {
        super((Endpoint)endpoint);
        this.connection = connection;
        this.defaultAwaitWrites = defaultAwaitWrites;
        this.nodeId = endpoint.getNodeId();
        this.methodId = endpoint.getMethodId();
    }

    public boolean process(Exchange exchange, AsyncCallback async) {
        Message msg = exchange.getIn();
        Object value = msg.getBody();
        CompletableFuture<Object> future = this.methodId == null ? this.connection.writeValue(this.nodeId, value) : this.connection.call(this.nodeId, this.methodId, value);
        Boolean await = (Boolean)msg.getHeader("await", (Object)this.defaultAwaitWrites, Boolean.class);
        if (Boolean.TRUE.equals(await)) {
            future.whenComplete((v, ex) -> async.done(false));
            return false;
        }
        return true;
    }
}

