/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="milo-client")
public class MiloClientComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientComponent.class);
    private final Map<String, MiloClientConnection> cache = new HashMap<String, MiloClientConnection>();
    private final Multimap<String, MiloClientEndpoint> connectionMap = HashMultimap.create();
    @Metadata
    private MiloClientConfiguration configuration = new MiloClientConfiguration();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MiloClientConfiguration configuration = new MiloClientConfiguration(this.configuration);
        configuration.setEndpointUri(remaining);
        MiloClientEndpoint endpoint = this.doCreateEndpoint(uri, configuration, parameters);
        return endpoint;
    }

    private synchronized MiloClientEndpoint doCreateEndpoint(String uri, MiloClientConfiguration configuration, Map<String, Object> parameters) throws Exception {
        MiloClientEndpoint endpoint = new MiloClientEndpoint(uri, this, configuration.getEndpointUri());
        endpoint.setConfiguration(configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        String cacheId = configuration.toCacheId();
        MiloClientConnection connection = this.cache.get(cacheId);
        if (connection == null) {
            LOG.info("Cache miss - creating new connection instance: {}", (Object)cacheId);
            connection = new MiloClientConnection(configuration);
            this.cache.put(cacheId, connection);
        }
        this.connectionMap.put((Object)cacheId, (Object)endpoint);
        endpoint.setConnection(connection);
        return endpoint;
    }

    public MiloClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MiloClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setApplicationName(String applicationName) {
        this.configuration.setApplicationName(applicationName);
    }

    public void setApplicationUri(String applicationUri) {
        this.configuration.setApplicationUri(applicationUri);
    }

    public void setProductUri(String productUri) {
        this.configuration.setProductUri(productUri);
    }

    public void setReconnectTimeout(Long reconnectTimeout) {
        this.configuration.setRequestTimeout(reconnectTimeout);
    }

    public synchronized void disposed(MiloClientEndpoint endpoint) {
        MiloClientConnection connection = endpoint.getConnection();
        this.connectionMap.remove((Object)connection.getConnectionId(), (Object)endpoint);
        if (!this.connectionMap.containsKey((Object)connection.getConnectionId())) {
            this.cache.remove(connection.getConnectionId());
            try {
                connection.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close connection", (Throwable)e);
            }
        }
    }
}

