/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class MongoDbConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,mongodb";
    @UriParam(label="consumer,mongodb", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,mongodb")
    @Metadata(required=true)
    private String mongodbPassword;
    @UriParam(label="consumer,mongodb", defaultValue="1")
    private int initialSyncMaxThreads = 1;
    @UriParam(label="consumer,mongodb", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,mongodb")
    private String collectionBlacklist;
    @UriParam(label="consumer,mongodb")
    private String collectionWhitelist;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean mongodbSslEnabled = false;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,mongodb", defaultValue="true")
    private boolean mongodbMembersAutoDiscover = true;
    @UriParam(label="consumer,mongodb")
    private String fieldRenames;
    @UriParam(label="consumer,mongodb", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,mongodb", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,mongodb")
    private String databaseWhitelist;
    @UriParam(label="consumer,mongodb")
    private String mongodbHosts;
    @UriParam(label="consumer,mongodb", defaultValue="1s", javaType="java.time.Duration")
    private long connectBackoffInitialDelayMs = 1000L;
    @UriParam(label="consumer,mongodb")
    private int snapshotFetchSize;
    @UriParam(label="consumer,mongodb")
    private String databaseHistoryFileFilename;
    @UriParam(label="consumer,mongodb", defaultValue="16")
    private int connectMaxAttempts = 16;
    @UriParam(label="consumer,mongodb")
    private String mongodbUser;
    @UriParam(label="consumer,mongodb")
    private String fieldBlacklist;
    @UriParam(label="consumer,mongodb", defaultValue="v2")
    private String sourceStructVersion = "v2";
    @UriParam(label="consumer,mongodb", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,mongodb")
    @Metadata(required=true)
    private String mongodbName;
    @UriParam(label="consumer,mongodb", defaultValue="2m", javaType="java.time.Duration")
    private long connectBackoffMaxDelayMs = 120000L;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean mongodbSslInvalidHostnameAllowed = false;
    @UriParam(label="consumer,mongodb")
    private String databaseBlacklist;
    @UriParam(label="consumer,mongodb")
    private String skippedOperations;
    @UriParam(label="consumer,mongodb", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,mongodb", defaultValue="initial")
    private String snapshotMode = "initial";

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMongodbPassword(String mongodbPassword) {
        this.mongodbPassword = mongodbPassword;
    }

    public String getMongodbPassword() {
        return this.mongodbPassword;
    }

    public void setInitialSyncMaxThreads(int initialSyncMaxThreads) {
        this.initialSyncMaxThreads = initialSyncMaxThreads;
    }

    public int getInitialSyncMaxThreads() {
        return this.initialSyncMaxThreads;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setCollectionBlacklist(String collectionBlacklist) {
        this.collectionBlacklist = collectionBlacklist;
    }

    public String getCollectionBlacklist() {
        return this.collectionBlacklist;
    }

    public void setCollectionWhitelist(String collectionWhitelist) {
        this.collectionWhitelist = collectionWhitelist;
    }

    public String getCollectionWhitelist() {
        return this.collectionWhitelist;
    }

    public void setMongodbSslEnabled(boolean mongodbSslEnabled) {
        this.mongodbSslEnabled = mongodbSslEnabled;
    }

    public boolean isMongodbSslEnabled() {
        return this.mongodbSslEnabled;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setMongodbMembersAutoDiscover(boolean mongodbMembersAutoDiscover) {
        this.mongodbMembersAutoDiscover = mongodbMembersAutoDiscover;
    }

    public boolean isMongodbMembersAutoDiscover() {
        return this.mongodbMembersAutoDiscover;
    }

    public void setFieldRenames(String fieldRenames) {
        this.fieldRenames = fieldRenames;
    }

    public String getFieldRenames() {
        return this.fieldRenames;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setDatabaseWhitelist(String databaseWhitelist) {
        this.databaseWhitelist = databaseWhitelist;
    }

    public String getDatabaseWhitelist() {
        return this.databaseWhitelist;
    }

    public void setMongodbHosts(String mongodbHosts) {
        this.mongodbHosts = mongodbHosts;
    }

    public String getMongodbHosts() {
        return this.mongodbHosts;
    }

    public void setConnectBackoffInitialDelayMs(long connectBackoffInitialDelayMs) {
        this.connectBackoffInitialDelayMs = connectBackoffInitialDelayMs;
    }

    public long getConnectBackoffInitialDelayMs() {
        return this.connectBackoffInitialDelayMs;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setDatabaseHistoryFileFilename(String databaseHistoryFileFilename) {
        this.databaseHistoryFileFilename = databaseHistoryFileFilename;
    }

    public String getDatabaseHistoryFileFilename() {
        return this.databaseHistoryFileFilename;
    }

    public void setConnectMaxAttempts(int connectMaxAttempts) {
        this.connectMaxAttempts = connectMaxAttempts;
    }

    public int getConnectMaxAttempts() {
        return this.connectMaxAttempts;
    }

    public void setMongodbUser(String mongodbUser) {
        this.mongodbUser = mongodbUser;
    }

    public String getMongodbUser() {
        return this.mongodbUser;
    }

    public void setFieldBlacklist(String fieldBlacklist) {
        this.fieldBlacklist = fieldBlacklist;
    }

    public String getFieldBlacklist() {
        return this.fieldBlacklist;
    }

    public void setSourceStructVersion(String sourceStructVersion) {
        this.sourceStructVersion = sourceStructVersion;
    }

    public String getSourceStructVersion() {
        return this.sourceStructVersion;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setMongodbName(String mongodbName) {
        this.mongodbName = mongodbName;
    }

    public String getMongodbName() {
        return this.mongodbName;
    }

    public void setConnectBackoffMaxDelayMs(long connectBackoffMaxDelayMs) {
        this.connectBackoffMaxDelayMs = connectBackoffMaxDelayMs;
    }

    public long getConnectBackoffMaxDelayMs() {
        return this.connectBackoffMaxDelayMs;
    }

    public void setMongodbSslInvalidHostnameAllowed(boolean mongodbSslInvalidHostnameAllowed) {
        this.mongodbSslInvalidHostnameAllowed = mongodbSslInvalidHostnameAllowed;
    }

    public boolean isMongodbSslInvalidHostnameAllowed() {
        return this.mongodbSslInvalidHostnameAllowed;
    }

    public void setDatabaseBlacklist(String databaseBlacklist) {
        this.databaseBlacklist = databaseBlacklist;
    }

    public String getDatabaseBlacklist() {
        return this.databaseBlacklist;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size", (Object)this.maxQueueSize);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.password", (Object)this.mongodbPassword);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"initial.sync.max.threads", (Object)this.initialSyncMaxThreads);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.delay.ms", (Object)this.snapshotDelayMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"collection.blacklist", (Object)this.collectionBlacklist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"collection.whitelist", (Object)this.collectionWhitelist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.ssl.enabled", (Object)this.mongodbSslEnabled);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"tombstones.on.delete", (Object)this.tombstonesOnDelete);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.members.auto.discover", (Object)this.mongodbMembersAutoDiscover);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"field.renames", (Object)this.fieldRenames);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"poll.interval.ms", (Object)this.pollIntervalMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.topics.prefix", (Object)this.heartbeatTopicsPrefix);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.whitelist", (Object)this.databaseWhitelist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.hosts", (Object)this.mongodbHosts);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"connect.backoff.initial.delay.ms", (Object)this.connectBackoffInitialDelayMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.fetch.size", (Object)this.snapshotFetchSize);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.file.filename", (Object)this.databaseHistoryFileFilename);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"connect.max.attempts", (Object)this.connectMaxAttempts);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.user", (Object)this.mongodbUser);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"field.blacklist", (Object)this.fieldBlacklist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"source.struct.version", (Object)this.sourceStructVersion);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.interval.ms", (Object)this.heartbeatIntervalMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.name", (Object)this.mongodbName);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"connect.backoff.max.delay.ms", (Object)this.connectBackoffMaxDelayMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.ssl.invalid.hostname.allowed", (Object)this.mongodbSslInvalidHostnameAllowed);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.blacklist", (Object)this.databaseBlacklist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"skipped.operations", (Object)this.skippedOperations);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.batch.size", (Object)this.maxBatchSize);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode", (Object)this.snapshotMode);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return MongoDbConnector.class;
    }

    protected ConfigurationValidation validateConnectorConfiguration() {
        if (MongoDbConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.mongodbPassword)) {
            return ConfigurationValidation.notValid((String)"Required field 'mongodbPassword' must be set.");
        }
        if (MongoDbConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.mongodbName)) {
            return ConfigurationValidation.notValid((String)"Required field 'mongodbName' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    public String getConnectorDatabaseType() {
        return "mongodb";
    }
}

