/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.jmx.JMXConsumerNotificationFilter;
import org.apache.camel.component.jmx.JMXEndpoint;
import org.apache.camel.component.jmx.NotificationFormatException;
import org.apache.camel.component.jmx.NotificationXmlFormatter;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXConsumer
extends DefaultConsumer
implements NotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(JMXConsumer.class);
    private JMXEndpoint mJmxEndpoint;
    private JMXConnector mConnector;
    private String mConnectionId;
    private ExecutorService executorService;
    private boolean shutdownExecutorService;
    private ScheduledExecutorService mScheduledExecutor;
    private ConnectionNotificationListener mConnectionNotificationListener;
    private MBeanServerConnection mServerConnection;
    private NotificationXmlFormatter mFormatter;

    public JMXConsumer(JMXEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.mJmxEndpoint = endpoint;
        this.mFormatter = new NotificationXmlFormatter();
    }

    public JMXEndpoint getEndpoint() {
        return (JMXEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)((Object)this.mFormatter));
        if (this.executorService == null) {
            if (this.getEndpoint().getExecutorService() != null) {
                this.executorService = this.getEndpoint().getExecutorService();
            } else {
                String name = "JMXConsumer[" + this.getEndpoint().getJMXObjectName().getCanonicalName() + "]";
                this.executorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, name);
                this.shutdownExecutorService = true;
            }
        }
        if (this.mJmxEndpoint.isPlatformServer()) {
            this.setServerConnection(ManagementFactory.getPlatformMBeanServer());
        } else {
            try {
                this.initNetworkConnection();
            }
            catch (IOException e) {
                if (!this.mJmxEndpoint.isTestConnectionOnStartup()) {
                    LOG.warn("Failed to connect to JMX server. >> {}", (Object)e.getMessage());
                    this.scheduleDelayedStart();
                    return;
                }
                throw e;
            }
        }
        this.addNotificationListener();
        super.doStart();
    }

    private void initNetworkConnection() throws IOException {
        if (this.mConnector != null) {
            try {
                this.mConnector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JMXServiceURL url = new JMXServiceURL(this.mJmxEndpoint.getServerURL());
        String[] creds = new String[]{this.mJmxEndpoint.getUser(), this.mJmxEndpoint.getPassword()};
        Map<String, String[]> map = Collections.singletonMap("jmx.remote.credentials", creds);
        this.mConnector = JMXConnectorFactory.connect(url, map);
        this.mConnector.addConnectionNotificationListener(this.getConnectionNotificationListener(), null, null);
        this.mConnectionId = this.mConnector.getConnectionId();
        this.setServerConnection(this.mConnector.getMBeanServerConnection());
    }

    protected ConnectionNotificationListener getConnectionNotificationListener() {
        if (this.mConnectionNotificationListener == null) {
            this.mConnectionNotificationListener = new ConnectionNotificationListener();
        }
        return this.mConnectionNotificationListener;
    }

    protected void scheduleDelayedStart() throws Exception {
        Runnable startRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    JMXConsumer.this.doStart();
                }
                catch (Exception e) {
                    LOG.error("An unrecoverable exception has occurred while starting the JMX consumer for endpoint {}", (Object)URISupport.sanitizeUri((String)JMXConsumer.this.mJmxEndpoint.getEndpointUri()), (Object)e);
                }
            }
        };
        LOG.info("Delaying JMX consumer startup for endpoint {}. Trying again in {} seconds.", (Object)URISupport.sanitizeUri((String)this.mJmxEndpoint.getEndpointUri()), (Object)this.mJmxEndpoint.getReconnectDelay());
        this.getExecutor().schedule(startRunnable, (long)this.mJmxEndpoint.getReconnectDelay(), TimeUnit.SECONDS);
    }

    protected void scheduleReconnect() {
        Runnable startRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    JMXConsumer.this.initNetworkConnection();
                    JMXConsumer.this.addNotificationListener();
                }
                catch (Exception e) {
                    LOG.warn("Failed to reconnect to JMX server. >> {}", (Object)e.getMessage());
                    JMXConsumer.this.scheduleReconnect();
                }
            }
        };
        LOG.info("Delaying JMX consumer reconnection for endpoint {}. Trying again in {} seconds.", (Object)URISupport.sanitizeUri((String)this.mJmxEndpoint.getEndpointUri()), (Object)this.mJmxEndpoint.getReconnectDelay());
        this.getExecutor().schedule(startRunnable, (long)this.mJmxEndpoint.getReconnectDelay(), TimeUnit.SECONDS);
    }

    private ScheduledExecutorService getExecutor() {
        if (this.mScheduledExecutor == null) {
            this.mScheduledExecutor = this.mJmxEndpoint.getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "JMXConnectionExecutor");
        }
        return this.mScheduledExecutor;
    }

    protected void addNotificationListener() throws Exception {
        JMXEndpoint ep = this.getEndpoint();
        NotificationFilter nf = ep.getNotificationFilter();
        if (nf == null && ep.getObservedAttribute() != null) {
            LOG.debug("Observing attribute: {}", (Object)ep.getObservedAttribute());
            boolean match = !ep.isNotifyDiffer();
            nf = new JMXConsumerNotificationFilter(ep.getObservedAttribute(), ep.getStringToCompare(), match);
        }
        ObjectName objectName = ep.getJMXObjectName();
        this.getServerConnection().addNotificationListener(objectName, this, nf, ep.getHandback());
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.mScheduledExecutor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.mScheduledExecutor);
            this.mScheduledExecutor = null;
        }
        this.removeNotificationListeners();
        if (this.mConnector != null) {
            this.mConnector.close();
        }
        ServiceHelper.stopService((Object)((Object)this.mFormatter));
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
            this.executorService = null;
        }
    }

    protected void removeNotificationListeners() throws Exception {
        this.getServerConnection().removeNotificationListener(this.mJmxEndpoint.getJMXObjectName(), this);
        if (this.mConnectionNotificationListener != null) {
            this.mConnector.removeConnectionNotificationListener(this.mConnectionNotificationListener);
            this.mConnectionNotificationListener = null;
        }
    }

    protected MBeanServerConnection getServerConnection() {
        return this.mServerConnection;
    }

    protected void setServerConnection(MBeanServerConnection aServerConnection) {
        this.mServerConnection = aServerConnection;
    }

    @Override
    public void handleNotification(Notification aNotification, Object aHandback) {
        JMXEndpoint ep = this.getEndpoint();
        Exchange exchange = this.getEndpoint().createExchange();
        Message message = exchange.getIn();
        message.setHeader("jmx.handback", aHandback);
        try {
            if (ep.isXML()) {
                message.setBody((Object)this.getFormatter().format(aNotification));
            } else {
                message.setBody((Object)aNotification);
            }
            this.executorService.submit(() -> {
                try {
                    this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    this.getExceptionHandler().handleException("Failed to process notification", (Throwable)e);
                }
            });
        }
        catch (NotificationFormatException e) {
            this.getExceptionHandler().handleException("Failed to marshal notification", (Throwable)e);
        }
    }

    protected NotificationXmlFormatter getFormatter() {
        return this.mFormatter;
    }

    private class ConnectionNotificationListener
    implements NotificationListener {
        private ConnectionNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            JMXConnectionNotification connectionNotification = (JMXConnectionNotification)notification;
            if (!connectionNotification.getConnectionId().equals(JMXConsumer.this.mConnectionId)) {
                return;
            }
            if (connectionNotification.getType().equals("jmx.remote.connection.notifs.lost") || connectionNotification.getType().equals("jmx.remote.connection.closed") || connectionNotification.getType().equals("jmx.remote.connection.failed")) {
                LOG.warn("Lost JMX connection for : {}", (Object)URISupport.sanitizeUri((String)JMXConsumer.this.mJmxEndpoint.getEndpointUri()));
                if (JMXConsumer.this.mJmxEndpoint.isReconnectOnConnectionFailure()) {
                    JMXConsumer.this.scheduleReconnect();
                } else {
                    LOG.warn("The JMX consumer will not be reconnected. Use 'reconnectOnConnectionFailure' to enable reconnections.");
                }
            }
        }
    }
}

