/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultCachedDocument
extends InlineQueryResult {
    private static final String TYPE = "document";
    @JsonProperty(value="document_file_id")
    private String documentFileId;
    private String title;
    private String caption;
    private String description;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultCachedDocument() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDocumentFileId() {
        return this.documentFileId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setDocumentFileId(String documentFileId) {
        this.documentFileId = documentFileId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String documentFileId;
        private String title;
        private String caption;
        private String description;
        private String parseMode;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder documentFileId(String documentFileId) {
            this.documentFileId = documentFileId;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultCachedDocument build() {
            InlineQueryResultCachedDocument inlineQueryResultDocument = new InlineQueryResultCachedDocument();
            inlineQueryResultDocument.setType(InlineQueryResultCachedDocument.TYPE);
            inlineQueryResultDocument.setId(this.id);
            inlineQueryResultDocument.setReplyMarkup(this.replyMarkup);
            inlineQueryResultDocument.documentFileId = this.documentFileId;
            inlineQueryResultDocument.caption = this.caption;
            inlineQueryResultDocument.inputMessageContext = this.inputMessageContext;
            inlineQueryResultDocument.parseMode = this.parseMode;
            inlineQueryResultDocument.title = this.title;
            inlineQueryResultDocument.description = this.description;
            return inlineQueryResultDocument;
        }
    }
}

