/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.corda;

import java.io.InputStream;
import java.security.PublicKey;
import net.corda.core.crypto.SecureHash;
import net.corda.core.flows.StateMachineRunId;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.node.services.vault.AttachmentQueryCriteria;
import net.corda.core.node.services.vault.AttachmentSort;
import net.corda.core.node.services.vault.PageSpecification;
import net.corda.core.node.services.vault.QueryCriteria;
import net.corda.core.node.services.vault.Sort;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.component.corda.CordaConfiguration;
import org.apache.camel.component.corda.CordaEndpoint;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.support.HeaderSelectorProducer;

public class CordaProducer
extends HeaderSelectorProducer {
    private CordaConfiguration configuration;
    private CordaRPCOps cordaRPCOps;

    public CordaProducer(CordaEndpoint endpoint, CordaConfiguration configuration, CordaRPCOps cordaRPCOps) {
        super((Endpoint)endpoint, "OPERATION", () -> configuration.getOperation(), false);
        this.configuration = configuration;
        this.cordaRPCOps = cordaRPCOps;
    }

    public CordaEndpoint getEndpoint() {
        return (CordaEndpoint)super.getEndpoint();
    }

    @InvokeOnHeader(value="CURRENT_NODE_TIME")
    void currentNodeTime(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.currentNodeTime());
    }

    @InvokeOnHeader(value="GET_PROTOCOL_VERSION")
    void getProtocolVersion(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.getProtocolVersion());
    }

    @InvokeOnHeader(value="NETWORK_MAP_SNAPSHOT")
    void networkMapSnapshot(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.networkMapSnapshot());
    }

    @InvokeOnHeader(value="STATE_MACHINE_SNAPSHOT")
    void stateMachinesSnapshot(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.stateMachinesSnapshot());
    }

    @InvokeOnHeader(value="STATE_MACHINE_RECORDED_TRANSACTION_MAPPING_SNAPSHOT")
    void stateMachineRecordedTransactionMappingSnapshot(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.stateMachineRecordedTransactionMappingSnapshot());
    }

    @InvokeOnHeader(value="REGISTERED_FLOWS")
    void registeredFlows(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.registeredFlows());
    }

    @InvokeOnHeader(value="CLEAR_NETWORK_MAP_CACHE")
    void clearNetworkMapCache(Message message) throws Exception {
        this.cordaRPCOps.clearNetworkMapCache();
    }

    @InvokeOnHeader(value="IS_FLOWS_DRAINING_MODE_ENABLED")
    void isFlowsDrainingModeEnabled(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.isFlowsDrainingModeEnabled());
    }

    @InvokeOnHeader(value="SET_FLOWS_DRAINING_MODE_ENABLED")
    void setFlowsDrainingModeEnabled(Message message) throws Exception {
        Boolean mode = (Boolean)message.getHeader("DRAINING_MODE", Boolean.class);
        this.cordaRPCOps.setFlowsDrainingModeEnabled(mode.booleanValue());
    }

    @InvokeOnHeader(value="NOTARY_IDENTITIES")
    void notaryIdentities(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.notaryIdentities());
    }

    @InvokeOnHeader(value="NODE_INFO")
    void nodeInfo(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.nodeInfo());
    }

    @InvokeOnHeader(value="ADD_VAULT_TRANSACTION_NOTE")
    void addVaultTransactionNote(Message message) throws Exception {
        SecureHash secureHash = (SecureHash)message.getHeader("SECURE_HASH", SecureHash.class);
        String note = (String)message.getBody(String.class);
        this.cordaRPCOps.addVaultTransactionNote(secureHash, note);
    }

    @InvokeOnHeader(value="GET_VAULT_TRANSACTION_NOTES")
    void getVaultTransactionNotes(Message message) throws Exception {
        SecureHash secureHash = (SecureHash)message.getHeader("SECURE_HASH", SecureHash.class);
        message.setBody((Object)this.cordaRPCOps.getVaultTransactionNotes(secureHash));
    }

    @InvokeOnHeader(value="UPLOAD_ATTACHMENT")
    void uploadAttachment(Message message) throws Exception {
        InputStream inputStream = (InputStream)message.getBody(InputStream.class);
        SecureHash secureHash = this.cordaRPCOps.uploadAttachment(inputStream);
        message.setHeader("SECURE_HASH", (Object)secureHash);
    }

    @InvokeOnHeader(value="ATTACHMENT_EXISTS")
    void attachmentExists(Message message) throws Exception {
        SecureHash secureHash = (SecureHash)message.getHeader("SECURE_HASH", SecureHash.class);
        message.setBody((Object)this.cordaRPCOps.attachmentExists(secureHash));
    }

    @InvokeOnHeader(value="OPEN_ATTACHMENT")
    void openAttachment(Message message) throws Exception {
        SecureHash secureHash = (SecureHash)message.getHeader("SECURE_HASH", SecureHash.class);
        message.setBody((Object)this.cordaRPCOps.openAttachment(secureHash));
    }

    @InvokeOnHeader(value="QUERY_ATTACHMENTS")
    void queryAttachments(Message message) throws Exception {
        AttachmentQueryCriteria queryCriteria = (AttachmentQueryCriteria)message.getHeader("ATTACHMENT_QUERY_CRITERIA", AttachmentQueryCriteria.class);
        AttachmentSort attachmentSort = (AttachmentSort)message.getHeader("SORT", AttachmentSort.class);
        message.setBody((Object)this.cordaRPCOps.queryAttachments(queryCriteria, attachmentSort));
    }

    @InvokeOnHeader(value="NODE_INFO_FROM_PARTY")
    void nodeInfoFromParty(Message message) throws Exception {
        AbstractParty party = (AbstractParty)message.getBody(AbstractParty.class);
        message.setBody((Object)this.cordaRPCOps.nodeInfoFromParty(party));
    }

    @InvokeOnHeader(value="NOTARY_PARTY_FROM_X500_NAME")
    void notaryPartyFromX500Name(Message message) throws Exception {
        CordaX500Name x500Name = (CordaX500Name)message.getBody(CordaX500Name.class);
        message.setBody((Object)this.cordaRPCOps.notaryPartyFromX500Name(x500Name));
    }

    @InvokeOnHeader(value="PARTIES_FROM_NAME")
    void partiesFromName(Message message) throws Exception {
        String query = (String)message.getBody(String.class);
        Boolean exactMatch = (Boolean)message.getHeader("EXACT_MATCH", Boolean.class);
        message.setBody((Object)this.cordaRPCOps.partiesFromName(query, exactMatch.booleanValue()));
    }

    @InvokeOnHeader(value="PARTIES_FROM_KEY")
    void partyFromKey(Message message) throws Exception {
        PublicKey key = (PublicKey)message.getBody(PublicKey.class);
        message.setBody((Object)this.cordaRPCOps.partyFromKey(key));
    }

    @InvokeOnHeader(value="WELL_KNOWN_PARTY_FROM_X500_NAME")
    void wellKnownPartyFromX500Name(Message message) throws Exception {
        CordaX500Name x500Name = (CordaX500Name)message.getBody(CordaX500Name.class);
        message.setBody((Object)this.cordaRPCOps.wellKnownPartyFromX500Name(x500Name));
    }

    @InvokeOnHeader(value="WELL_KNOWN_PARTY_FROM_ANONYMOUS")
    void wellKnownPartyFromAnonymous(Message message) throws Exception {
        AbstractParty party = (AbstractParty)message.getBody(AbstractParty.class);
        message.setBody((Object)this.cordaRPCOps.wellKnownPartyFromAnonymous(party));
    }

    @InvokeOnHeader(value="START_FLOW_DYNAMIC")
    void startFlowDynamic(Message message) throws Exception {
        Object[] args = (Object[])message.getHeader("ARGUMENTS", Object[].class);
        Class aClass = (Class)message.getBody(Class.class);
        message.setBody(this.cordaRPCOps.startFlowDynamic(aClass, args).getReturnValue().get());
    }

    @InvokeOnHeader(value="VAULT_QUERY")
    void vaultQuery(Message message) throws Exception {
        Class contractStateClass = (Class)message.getBody(Class.class);
        message.setBody((Object)this.cordaRPCOps.vaultQuery(contractStateClass));
    }

    @InvokeOnHeader(value="VAULT_QUERY_BY")
    void vaultQueryBy(Message message) throws Exception {
        Class contractStateClass = (Class)message.getBody(Class.class);
        QueryCriteria criteria = (QueryCriteria)message.getHeader("QUERY_CRITERIA", QueryCriteria.class);
        PageSpecification pageSpec = (PageSpecification)message.getHeader("PAGE_SPECIFICATION", PageSpecification.class);
        Sort sorting = (Sort)message.getHeader("SORT", Sort.class);
        message.setBody((Object)this.cordaRPCOps.vaultQueryBy(criteria, pageSpec, sorting, contractStateClass));
    }

    @InvokeOnHeader(value="VAULT_QUERY_BY_CRITERIA")
    void vaultQueryByCriteria(Message message) throws Exception {
        Class contractStateClass = (Class)message.getBody(Class.class);
        QueryCriteria criteria = (QueryCriteria)message.getHeader("QUERY_CRITERIA", QueryCriteria.class);
        message.setBody((Object)this.cordaRPCOps.vaultQueryByCriteria(criteria, contractStateClass));
    }

    @InvokeOnHeader(value="VAULT_QUERY_BY_WITH_PAGING_SPEC")
    void vaultQueryByWithPagingSpec(Message message) throws Exception {
        Class contractStateClass = (Class)message.getBody(Class.class);
        QueryCriteria criteria = (QueryCriteria)message.getHeader("QUERY_CRITERIA", QueryCriteria.class);
        PageSpecification pageSpec = (PageSpecification)message.getHeader("PAGE_SPECIFICATION", PageSpecification.class);
        message.setBody((Object)this.cordaRPCOps.vaultQueryByWithPagingSpec(contractStateClass, criteria, pageSpec));
    }

    @InvokeOnHeader(value="VAULT_QUERY_BY_WITH_SORTING")
    void vaultQueryByWithSorting(Message message) throws Exception {
        Class contractStateClass = (Class)message.getBody(Class.class);
        QueryCriteria criteria = (QueryCriteria)message.getHeader("QUERY_CRITERIA", QueryCriteria.class);
        Sort sorting = (Sort)message.getHeader("SORT", Sort.class);
        message.setBody((Object)this.cordaRPCOps.vaultQueryByWithSorting(contractStateClass, criteria, sorting));
    }

    @InvokeOnHeader(value="TERMINATE")
    void terminate(Message message) throws Exception {
        this.cordaRPCOps.terminate(true);
    }

    @InvokeOnHeader(value="IS_WAITING_FOR_SHUTDOWN")
    void isWaitingForShutdown(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.isWaitingForShutdown());
    }

    @InvokeOnHeader(value="REFRESH_NETWORK_MAP_CACHE")
    void refreshNetworkMapCache(Message message) throws Exception {
        this.cordaRPCOps.refreshNetworkMapCache();
    }

    @InvokeOnHeader(value="SHUTDOWN")
    void shutdown(Message message) throws Exception {
        this.cordaRPCOps.shutdown();
    }

    @InvokeOnHeader(value="WAIT_UNTIL_NETWORK_READY")
    void waitUntilNetworkReady(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.waitUntilNetworkReady());
    }

    @InvokeOnHeader(value="ACCEPT_NEWNETWORK_PARAMETERS")
    void acceptNewNetworkParameters(Message message) throws Exception {
        SecureHash secureHash = (SecureHash)message.getHeader("SECURE_HASH", SecureHash.class);
        this.cordaRPCOps.acceptNewNetworkParameters(secureHash);
    }

    @InvokeOnHeader(value="KILL_FLOW")
    void killFlow(Message message) throws Exception {
        StateMachineRunId stateMachineRunId = (StateMachineRunId)message.getBody(StateMachineRunId.class);
        this.cordaRPCOps.killFlow(stateMachineRunId);
    }

    @InvokeOnHeader(value="NETWORK_PARAMETERS_FEED")
    void networkParametersFeed(Message message) throws Exception {
        message.setBody((Object)this.cordaRPCOps.networkParametersFeed());
    }

    @InvokeOnHeader(value="UPLOAD_ATTACHMENT_WITH_META_DATA")
    void uploadAttachmentWithMetadata(Message message) throws Exception {
        InputStream inputStream = (InputStream)message.getBody(InputStream.class);
        String uploader = (String)message.getBody(String.class);
        String filename = (String)message.getBody(String.class);
        SecureHash secureHash = this.cordaRPCOps.uploadAttachmentWithMetadata(inputStream, uploader, filename);
        message.setHeader("SECURE_HASH", (Object)secureHash);
    }
}

