/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.corda;

import net.corda.core.contracts.ContractState;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.messaging.DataFeed;
import net.corda.core.messaging.FlowProgressHandle;
import net.corda.core.messaging.StateMachineTransactionMapping;
import net.corda.core.messaging.StateMachineUpdate;
import net.corda.core.node.services.NetworkMapCache;
import net.corda.core.node.services.Vault;
import net.corda.core.node.services.vault.PageSpecification;
import net.corda.core.node.services.vault.QueryCriteria;
import net.corda.core.node.services.vault.Sort;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.corda.CordaConfiguration;
import org.apache.camel.component.corda.CordaEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscription;

public class CordaConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CordaConsumer.class);
    private final CordaConfiguration configuration;
    private CordaRPCOps cordaRPCOps;
    private Subscription subscription;

    public CordaConsumer(CordaEndpoint endpoint, Processor processor, CordaConfiguration configuration, CordaRPCOps cordaRPCOps) {
        super((Endpoint)endpoint, processor);
        this.configuration = configuration;
        this.cordaRPCOps = cordaRPCOps;
    }

    public CordaEndpoint getEndpoint() {
        return (CordaEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        Exchange exchange = this.getEndpoint().createExchange();
        Class<ContractState> contractStateClass = this.configuration.getContractStateClass();
        QueryCriteria criteria = this.configuration.getQueryCriteria();
        PageSpecification pageSpec = this.configuration.getPageSpecification();
        Sort sorting = this.configuration.getSort();
        switch (this.configuration.getOperation()) {
            case "VAULT_TRACK": {
                LOG.debug("subscribing for operation: VAULT_TRACK");
                DataFeed pageUpdateDataFeed = this.cordaRPCOps.vaultTrack(contractStateClass);
                this.processSnapshot(exchange, pageUpdateDataFeed.getSnapshot());
                this.subscription = pageUpdateDataFeed.getUpdates().subscribe(x -> this.processContractStateUpdate((Vault.Update<ContractState>)x), t -> this.processError((Throwable)t, "VAULT_TRACK"), () -> this.processDone("VAULT_TRACK"));
                break;
            }
            case "VAULT_TRACK_BY": {
                LOG.debug("subscribing for operation: VAULT_TRACK_BY");
                DataFeed pageUpdateDataFeed = this.cordaRPCOps.vaultTrackBy(criteria, pageSpec, sorting, contractStateClass);
                this.processSnapshot(exchange, pageUpdateDataFeed.getSnapshot());
                this.subscription = pageUpdateDataFeed.getUpdates().subscribe(x -> this.processContractStateUpdate((Vault.Update<ContractState>)x), t -> this.processError((Throwable)t, "VAULT_TRACK_BY"), () -> this.processDone("VAULT_TRACK_BY"));
                break;
            }
            case "VAULT_TRACK_BY_CRITERIA": {
                LOG.debug("subscribing for operation: VAULT_TRACK_BY_CRITERIA");
                DataFeed pageUpdateDataFeed = this.cordaRPCOps.vaultTrackByCriteria(contractStateClass, criteria);
                this.processSnapshot(exchange, pageUpdateDataFeed.getSnapshot());
                this.subscription = pageUpdateDataFeed.getUpdates().subscribe(x -> this.processContractStateUpdate((Vault.Update<ContractState>)x), t -> this.processError((Throwable)t, "VAULT_TRACK_BY_CRITERIA"), () -> this.processDone("VAULT_TRACK_BY_CRITERIA"));
                break;
            }
            case "VAULT_TRACK_BY_WITH_PAGING_SPEC": {
                LOG.debug("subscribing for operation: VAULT_TRACK_BY_WITH_PAGING_SPEC");
                DataFeed pageUpdateDataFeed = this.cordaRPCOps.vaultTrackByWithPagingSpec(contractStateClass, criteria, pageSpec);
                this.processSnapshot(exchange, pageUpdateDataFeed.getSnapshot());
                this.subscription = pageUpdateDataFeed.getUpdates().subscribe(x -> this.processContractStateUpdate((Vault.Update<ContractState>)x), t -> this.processError((Throwable)t, "VAULT_TRACK_BY_WITH_PAGING_SPEC"), () -> this.processDone("VAULT_TRACK_BY_WITH_PAGING_SPEC"));
                break;
            }
            case "VAULT_TRACK_BY_WITH_SORTING": {
                LOG.debug("subscribing for operation: VAULT_TRACK_BY_WITH_SORTING");
                DataFeed pageUpdateDataFeed = this.cordaRPCOps.vaultTrackByWithSorting(contractStateClass, criteria, sorting);
                this.processSnapshot(exchange, pageUpdateDataFeed.getSnapshot());
                this.subscription = pageUpdateDataFeed.getUpdates().subscribe(x -> this.processContractStateUpdate((Vault.Update<ContractState>)x), t -> this.processError((Throwable)t, "VAULT_TRACK_BY_WITH_SORTING"), () -> this.processDone("VAULT_TRACK_BY_WITH_SORTING"));
                break;
            }
            case "STATE_MACHINE_FEED": {
                LOG.debug("subscribing for operation: STATE_MACHINE_FEED");
                DataFeed stateFeed = this.cordaRPCOps.stateMachinesFeed();
                this.processSnapshot(exchange, stateFeed.getSnapshot());
                this.subscription = stateFeed.getUpdates().subscribe(x -> this.processStateMachineUpdate((StateMachineUpdate)x), t -> this.processError((Throwable)t, "STATE_MACHINE_FEED"), () -> this.processDone("STATE_MACHINE_FEED"));
                break;
            }
            case "NETWORK_MAP_FEED": {
                LOG.debug("subscribing for operation: NETWORK_MAP_FEED");
                DataFeed networkMapFeed = this.cordaRPCOps.networkMapFeed();
                this.processSnapshot(exchange, networkMapFeed.getSnapshot());
                this.subscription = networkMapFeed.getUpdates().subscribe(x -> this.proceedNetworkMapFeed((NetworkMapCache.MapChange)x), t -> this.processError((Throwable)t, "NETWORK_MAP_FEED"), () -> this.processDone("NETWORK_MAP_FEED"));
                break;
            }
            case "STATE_MACHINE_RECORDED_TRANSACTION_MAPPING_FEED": {
                LOG.debug("subscribing for operation: STATE_MACHINE_RECORDED_TRANSACTION_MAPPING_FEED");
                DataFeed transactionFeed = this.cordaRPCOps.stateMachineRecordedTransactionMappingFeed();
                this.processSnapshot(exchange, transactionFeed.getSnapshot());
                this.subscription = transactionFeed.getUpdates().subscribe(x -> this.processTransactionMappingFeed((StateMachineTransactionMapping)x), t -> this.processError((Throwable)t, "STATE_MACHINE_RECORDED_TRANSACTION_MAPPING_FEED"), () -> this.processDone("STATE_MACHINE_RECORDED_TRANSACTION_MAPPING_FEED"));
                break;
            }
            case "START_TRACKED_FLOW_DYNAMIC": {
                LOG.debug("subscribing for operation: START_TRACKED_FLOW_DYNAMIC");
                FlowProgressHandle objectFlowProgressHandle = this.cordaRPCOps.startTrackedFlowDynamic(this.configuration.getFlowLogicClass(), this.configuration.getFlowLogicArguments());
                Object result = objectFlowProgressHandle.getReturnValue().get();
                Observable progress = objectFlowProgressHandle.getProgress();
                this.processSnapshot(exchange, result);
                this.subscription = progress.subscribe(x -> this.processFlowProcess((String)x), t -> this.processError((Throwable)t, "START_TRACKED_FLOW_DYNAMIC"), () -> this.processDone("START_TRACKED_FLOW_DYNAMIC"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + this.configuration.getOperation());
            }
        }
        LOG.info("Subscribed: {}", (Object)this.configuration);
    }

    private void processSnapshot(Exchange exchange, Object page) {
        if (this.configuration.isProcessSnapshot()) {
            try {
                exchange.getIn().setBody(page);
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                LOG.error("Error processing snapshot", (Throwable)e);
            }
        }
    }

    private void processFlowProcess(String x) {
        LOG.debug("processFlowProcess {}", (Object)x);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)x);
        this.processEvent(exchange);
    }

    private void processTransactionMappingFeed(StateMachineTransactionMapping x) {
        LOG.debug("processTransactionMappingFeed {}", (Object)x);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)x);
        this.processEvent(exchange);
    }

    private void proceedNetworkMapFeed(NetworkMapCache.MapChange x) {
        LOG.debug("proceedNetworkMapFeed {}", (Object)x);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)x);
        this.processEvent(exchange);
    }

    private void processStateMachineUpdate(StateMachineUpdate x) {
        LOG.debug("processStateMachineUpdate {}", (Object)x);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)x);
        this.processEvent(exchange);
    }

    private void processContractStateUpdate(Vault.Update<ContractState> x) {
        LOG.debug("processContractStateUpdate {}", x);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody(x);
        this.processEvent(exchange);
    }

    private void processError(Throwable throwable, String operation) {
        LOG.debug("processError for operation: " + operation + " " + throwable);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.setException(throwable);
        this.processEvent(exchange);
    }

    public void processEvent(Exchange exchange) {
        LOG.debug("processEvent {}", (Object)exchange);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.error("Error processing event ", (Throwable)e);
        }
    }

    private void processDone(String operation) {
        LOG.debug("processDone for operation: {}", (Object)operation);
    }

    protected void doStop() throws Exception {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
        super.doStop();
    }
}

