/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub.consumer;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.common.base.Strings;
import com.google.pubsub.v1.PubsubMessage;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.component.google.pubsub.GooglePubsubConstants;
import org.apache.camel.component.google.pubsub.GooglePubsubEndpoint;
import org.apache.camel.component.google.pubsub.consumer.AcknowledgeAsync;
import org.apache.camel.spi.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelMessageReceiver
implements MessageReceiver {
    private final Logger localLog;
    private final GooglePubsubEndpoint endpoint;
    private final Processor processor;

    public CamelMessageReceiver(GooglePubsubEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
        String loggerId = endpoint.getLoggerId();
        if (Strings.isNullOrEmpty((String)loggerId)) {
            loggerId = this.getClass().getName();
        }
        this.localLog = LoggerFactory.getLogger((String)loggerId);
    }

    public void receiveMessage(PubsubMessage pubsubMessage, AckReplyConsumer ackReplyConsumer) {
        if (this.localLog.isTraceEnabled()) {
            this.localLog.trace("Received message ID : {}", (Object)pubsubMessage.getMessageId());
        }
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody((Object)pubsubMessage.getData().toByteArray());
        exchange.getIn().setHeader("CamelGooglePubsub.MessageId", (Object)pubsubMessage.getMessageId());
        exchange.getIn().setHeader("CamelGooglePubsub.PublishTime", (Object)pubsubMessage.getPublishTime());
        if (null != pubsubMessage.getAttributesMap()) {
            exchange.getIn().setHeader("CamelGooglePubsub.Attributes", (Object)pubsubMessage.getAttributesMap());
        }
        if (this.endpoint.getAckMode() != GooglePubsubConstants.AckMode.NONE) {
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new AcknowledgeAsync(ackReplyConsumer));
        }
        try {
            this.processor.process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
    }
}

