/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub;

import com.google.api.client.util.Strings;
import com.google.api.core.ApiFuture;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.google.pubsub.GooglePubsubEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePubsubProducer
extends DefaultProducer {
    public Logger logger;

    public GooglePubsubProducer(GooglePubsubEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        String loggerId = endpoint.getLoggerId();
        if (Strings.isNullOrEmpty((String)loggerId)) {
            loggerId = ((Object)((Object)this)).getClass().getName();
        }
        this.logger = LoggerFactory.getLogger((String)loggerId);
    }

    public void process(Exchange exchange) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("uploader thread/id: " + Thread.currentThread().getId() + " / " + exchange.getExchangeId() + " . api call completed.");
        }
        if (exchange.getIn().getBody() instanceof List) {
            boolean groupedExchanges = false;
            for (Object body : (List)exchange.getIn().getBody(List.class)) {
                if (!(body instanceof Exchange)) continue;
                this.send((Exchange)body);
                groupedExchanges = true;
            }
            if (!groupedExchanges) {
                this.send(exchange);
            }
        } else {
            this.send(exchange);
        }
    }

    private void send(Exchange exchange) throws Exception {
        GooglePubsubEndpoint endpoint = (GooglePubsubEndpoint)this.getEndpoint();
        String topicName = String.format("projects/%s/topics/%s", endpoint.getProjectId(), endpoint.getDestinationName());
        Publisher publisher = endpoint.getComponent().getPublisher(topicName);
        Object body = exchange.getIn().getBody();
        ByteString byteString = body instanceof String ? ByteString.copyFromUtf8((String)((String)body)) : (body instanceof byte[] ? ByteString.copyFrom((byte[])((byte[])body)) : ByteString.copyFrom((byte[])GooglePubsubProducer.serialize(body)));
        PubsubMessage.Builder messageBuilder = PubsubMessage.newBuilder().setData(byteString);
        Map attributes = (Map)exchange.getIn().getHeader("CamelGooglePubsub.Attributes", Map.class);
        if (attributes != null) {
            messageBuilder.putAllAttributes(attributes).build();
        }
        PubsubMessage message = messageBuilder.build();
        ApiFuture messageIdFuture = publisher.publish(message);
        exchange.getIn().setHeader("CamelGooglePubsub.MessageId", messageIdFuture.get());
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(out);
        os.writeObject(obj);
        return out.toByteArray();
    }
}

