/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.operations;

import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PublicAccessType;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.blob.BlobExchangeHeaders;
import org.apache.camel.component.azure.storage.blob.client.BlobContainerClientWrapper;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class BlobContainerOperations {
    private final BlobContainerClientWrapper client;

    public BlobContainerOperations(BlobContainerClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client cannot be null");
        this.client = client;
    }

    public BlobOperationResponse listBlobs(Exchange exchange) {
        if (exchange == null) {
            return new BlobOperationResponse(this.client.listBlobs(new ListBlobsOptions(), null));
        }
        ListBlobsOptions listBlobOptions = this.getListBlobOptions(exchange);
        Duration timeout = BlobExchangeHeaders.getTimeoutFromHeaders(exchange);
        return new BlobOperationResponse(this.client.listBlobs(listBlobOptions, timeout));
    }

    public BlobOperationResponse createContainer(Exchange exchange) {
        if (exchange == null) {
            BlobExchangeHeaders blobExchangeHeaders = new BlobExchangeHeaders().httpHeaders(this.client.createContainer(null, null, null));
            return new BlobOperationResponse(true, blobExchangeHeaders.toMap());
        }
        Map<String, String> metadata = BlobExchangeHeaders.getMetadataFromHeaders(exchange);
        PublicAccessType publicAccessType = BlobExchangeHeaders.getPublicAccessTypeFromHeaders(exchange);
        Duration timeout = BlobExchangeHeaders.getTimeoutFromHeaders(exchange);
        BlobExchangeHeaders blobExchangeHeaders = new BlobExchangeHeaders().httpHeaders(this.client.createContainer(metadata, publicAccessType, timeout));
        return new BlobOperationResponse(true, blobExchangeHeaders.toMap());
    }

    public BlobOperationResponse deleteContainer(Exchange exchange) {
        if (exchange == null) {
            BlobExchangeHeaders blobExchangeHeaders = new BlobExchangeHeaders().httpHeaders(this.client.deleteContainer(null, null));
            return new BlobOperationResponse(true, blobExchangeHeaders.toMap());
        }
        BlobRequestConditions blobRequestConditions = BlobExchangeHeaders.getBlobRequestConditionsFromHeaders(exchange);
        Duration timeout = BlobExchangeHeaders.getTimeoutFromHeaders(exchange);
        BlobExchangeHeaders blobExchangeHeaders = new BlobExchangeHeaders().httpHeaders(this.client.deleteContainer(blobRequestConditions, timeout));
        return new BlobOperationResponse(true, blobExchangeHeaders.toMap());
    }

    private ListBlobsOptions getListBlobOptions(Exchange exchange) {
        ListBlobsOptions blobsOptions = BlobExchangeHeaders.getListBlobsOptionsFromHeaders(exchange);
        if (!ObjectHelper.isEmpty((Object)blobsOptions)) {
            return blobsOptions;
        }
        blobsOptions = new ListBlobsOptions();
        BlobListDetails blobListDetails = BlobExchangeHeaders.getBlobListDetailsFromHeaders(exchange);
        String prefix = BlobExchangeHeaders.getPrefixFromHeaders(exchange);
        Integer maxResultsPerPage = BlobExchangeHeaders.getMaxResultsPerPageFromHeaders(exchange);
        blobsOptions.setDetails(blobListDetails);
        blobsOptions.setMaxResultsPerPage(maxResultsPerPage);
        blobsOptions.setPrefix(prefix);
        return blobsOptions;
    }
}

