/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.utils.cassandra;

import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.ErrorAwarePolicy;
import com.datastax.driver.core.policies.LatencyAwarePolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;

public class CassandraLoadBalancingPolicies {
    public final String roundRobinPolicy = "RoundRobinPolicy";
    public final String tokenAwarePolicy = "TokenAwarePolicy";
    public final String dcAwareRoundRobinPolicy = "DcAwareRoundRobinPolicy";
    public final String latencyAwarePolicy = "LatencyAwarePolicy";
    public final String errorAwarePolicy = "ErrorAwarePolicy";

    public LoadBalancingPolicy getLoadBalancingPolicy(String policy) {
        RoundRobinPolicy loadBalancingPolicy = new RoundRobinPolicy();
        switch (policy) {
            case "RoundRobinPolicy": {
                loadBalancingPolicy = new RoundRobinPolicy();
                break;
            }
            case "TokenAwarePolicy": {
                loadBalancingPolicy = new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy());
                break;
            }
            case "DcAwareRoundRobinPolicy": {
                loadBalancingPolicy = DCAwareRoundRobinPolicy.builder().build();
                break;
            }
            case "LatencyAwarePolicy": {
                loadBalancingPolicy = LatencyAwarePolicy.builder((LoadBalancingPolicy)new RoundRobinPolicy()).build();
                break;
            }
            case "ErrorAwarePolicy": {
                loadBalancingPolicy = ErrorAwarePolicy.builder((LoadBalancingPolicy)new RoundRobinPolicy()).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cassandra load balancing policy can be RoundRobinPolicy ,TokenAwarePolicy ,DcAwareRoundRobinPolicy");
            }
        }
        return loadBalancingPolicy;
    }
}

