/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="netty")
public class NettyComponent
extends DefaultComponent
implements SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(NettyComponent.class);
    @Metadata
    private NettyConfiguration configuration = new NettyConfiguration();
    @Metadata(label="consumer,advanced")
    private int maximumPoolSize;
    @Metadata(label="consumer,advanced")
    private volatile EventExecutorGroup executorService;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public NettyComponent() {
    }

    public NettyComponent(Class<? extends Endpoint> endpointClass) {
    }

    public NettyComponent(CamelContext context) {
        super(context);
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        NettyConfiguration config = this.configuration.copy();
        config = this.parseConfiguration(config, remaining, parameters);
        NettyServerBootstrapConfiguration bootstrapConfiguration = (NettyServerBootstrapConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "bootstrapConfiguration", NettyServerBootstrapConfiguration.class);
        if (bootstrapConfiguration != null) {
            HashMap options = new HashMap();
            BeanIntrospection beanIntrospection = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getBeanIntrospection();
            if (beanIntrospection.getProperties((Object)bootstrapConfiguration, options, null, false)) {
                PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)config, options);
            }
        }
        if (config.getSslContextParameters() == null) {
            config.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        config.validateConfiguration();
        NettyEndpoint nettyEndpoint = new NettyEndpoint(uri, this, config);
        this.setProperties((Endpoint)nettyEndpoint, parameters);
        return nettyEndpoint;
    }

    protected NettyConfiguration parseConfiguration(NettyConfiguration configuration, String remaining, Map<String, Object> parameters) throws Exception {
        configuration.parseURI(new URI(remaining), parameters, this, "tcp", "udp");
        return configuration;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setExecutorService(EventExecutorGroup executorService) {
        this.executorService = executorService;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public EventExecutorGroup getExecutorService() {
        return this.executorService;
    }

    protected void doStart() throws Exception {
        if (this.configuration.isUsingExecutorService() && this.executorService == null) {
            int netty = SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2));
            int threads = Math.max(this.maximumPoolSize, netty + 1);
            this.executorService = NettyHelper.createExecutorGroup(this.getCamelContext(), "NettyConsumerExecutorGroup", threads);
            LOG.info("Creating shared NettyConsumerExecutorGroup with {} threads", (Object)threads);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.configuration.isUsingExecutorService() && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownGraceful((ExecutorService)this.executorService);
            this.executorService = null;
        }
        if (this.configuration.getWorkerGroup() != null) {
            this.configuration.getWorkerGroup().shutdownGracefully();
        }
        super.doStop();
    }
}

