/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.braintree;

import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.Environment;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.component.braintree.internal.BraintreeApiName;
import org.apache.camel.component.braintree.internal.BraintreeLogHandler;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class BraintreeConfiguration {
    private static final String ENVIRONMENT = "environment";
    private static final String MERCHANT_ID = "merchant_id";
    private static final String PUBLIC_KEY = "public_key";
    private static final String PRIVATE_KEY = "private_key";
    private static final String ACCESS_TOKEN = "access_token";
    @UriPath
    @Metadata(required=true)
    private BraintreeApiName apiName;
    @UriPath
    private String methodName;
    @UriParam
    private String environment;
    @UriParam
    private String merchantId;
    @UriParam(label="security", secret=true)
    private String publicKey;
    @UriParam(label="security", secret=true)
    private String privateKey;
    @UriParam(label="security", secret=true)
    private String accessToken;
    @UriParam(label="proxy")
    private String proxyHost;
    @UriParam(label="proxy")
    private Integer proxyPort;
    @UriParam(label="logging", javaType="java.lang.String")
    private Level httpLogLevel;
    @UriParam(label="logging", defaultValue="Braintree")
    private String httpLogName;
    @UriParam(label="logging", defaultValue="true")
    private boolean logHandlerEnabled = true;
    @UriParam(label="advanced")
    private Integer httpReadTimeout;

    public BraintreeApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(BraintreeApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Level getHttpLogLevel() {
        return this.httpLogLevel;
    }

    public void setHttpLogLevel(String httpLogLevel) {
        this.httpLogLevel = Level.parse(httpLogLevel);
    }

    public void setHttpLogLevel(Level httpLogLevel) {
        this.httpLogLevel = httpLogLevel;
    }

    public String getHttpLogName() {
        return this.httpLogName;
    }

    public void setHttpLogName(String httpLogName) {
        this.httpLogName = httpLogName;
    }

    public Integer getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public void setLogHandlerEnabled(boolean logHandlerEnabled) {
        this.logHandlerEnabled = logHandlerEnabled;
    }

    public boolean isLogHandlerEnabled() {
        return this.logHandlerEnabled;
    }

    public void setHttpReadTimeout(Integer httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
    }

    private Environment getBraintreeEnvironment() {
        String name = this.getEnvironment();
        if (ObjectHelper.equal((Object)Environment.DEVELOPMENT.getEnvironmentName(), (Object)name, (boolean)true)) {
            return Environment.DEVELOPMENT;
        }
        if (ObjectHelper.equal((Object)Environment.SANDBOX.getEnvironmentName(), (Object)name, (boolean)true)) {
            return Environment.SANDBOX;
        }
        if (ObjectHelper.equal((Object)Environment.PRODUCTION.getEnvironmentName(), (Object)name, (boolean)true)) {
            return Environment.PRODUCTION;
        }
        throw new IllegalArgumentException(String.format("Environment should be development, sandbox or production, got %s", name));
    }

    synchronized BraintreeGateway newBraintreeGateway() {
        BraintreeGateway gateway;
        if (this.accessToken != null) {
            gateway = new BraintreeGateway(this.accessToken);
            this.setEnvironment(gateway.getConfiguration().getEnvironment().getEnvironmentName());
        } else {
            gateway = new BraintreeGateway(this.getBraintreeEnvironment(), this.getMerchantId(), this.getPublicKey(), this.getPrivateKey());
        }
        if (ObjectHelper.isNotEmpty((Object)this.proxyHost) && ObjectHelper.isNotEmpty((Object)this.proxyPort)) {
            gateway.setProxy(this.proxyHost, this.proxyPort);
        }
        if (this.httpReadTimeout != null) {
            gateway.getConfiguration().setTimeout(this.httpReadTimeout);
        }
        Logger logger = ObjectHelper.isNotEmpty((Object)this.httpLogName) ? Logger.getLogger(this.httpLogName) : gateway.getConfiguration().getLogger();
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        if (this.isLogHandlerEnabled()) {
            logger.addHandler(new BraintreeLogHandler());
        }
        if (this.httpLogLevel != null) {
            logger.setLevel(this.httpLogLevel);
        }
        gateway.getConfiguration().setLogger(logger);
        return gateway;
    }
}

