/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.braintree;

import com.braintreegateway.BraintreeGateway;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.braintree.BraintreeConfiguration;
import org.apache.camel.component.braintree.BraintreeEndpoint;
import org.apache.camel.component.braintree.internal.BraintreeApiCollection;
import org.apache.camel.component.braintree.internal.BraintreeApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;

@Component(value="braintree")
public class BraintreeComponent
extends AbstractApiComponent<BraintreeApiName, BraintreeConfiguration, BraintreeApiCollection> {
    @Metadata
    private BraintreeConfiguration configuration;
    private final Map<String, BraintreeGateway> gateways = new HashMap<String, BraintreeGateway>();

    public BraintreeComponent() {
        super(BraintreeEndpoint.class, BraintreeApiName.class, (ApiCollection)BraintreeApiCollection.getCollection());
    }

    public BraintreeComponent(CamelContext context) {
        super(context, BraintreeEndpoint.class, BraintreeApiName.class, (ApiCollection)BraintreeApiCollection.getCollection());
    }

    protected BraintreeApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return BraintreeApiName.fromValue(apiNameStr);
    }

    protected Endpoint createEndpoint(String uri, String methodName, BraintreeApiName apiName, BraintreeConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        this.configuration = endpointConfiguration;
        return new BraintreeEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    public synchronized BraintreeGateway getGateway(BraintreeConfiguration configuration) {
        BraintreeGateway gateway;
        if (configuration.getAccessToken() != null) {
            gateway = this.gateways.get(configuration.getAccessToken());
            if (gateway == null) {
                gateway = configuration.newBraintreeGateway();
                this.gateways.put(configuration.getAccessToken(), gateway);
            }
        } else {
            gateway = this.gateways.get(configuration.getMerchantId());
            if (gateway == null) {
                gateway = configuration.newBraintreeGateway();
                this.gateways.put(configuration.getMerchantId(), gateway);
            }
        }
        return gateway;
    }
}

