/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.websocket.jsr356.ClientSessions;
import org.apache.camel.websocket.jsr356.JSR356Endpoint;

public class JSR356Producer
extends DefaultAsyncProducer {
    private ClientSessions manager;
    private BiConsumer<Exchange, AsyncCallback> onExchange;

    JSR356Producer(JSR356Endpoint jsr356Endpoint) {
        super((Endpoint)jsr356Endpoint);
    }

    public JSR356Endpoint getEndpoint() {
        return (JSR356Endpoint)((Object)JSR356Endpoint.class.cast(super.getEndpoint()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Session session = (Session)exchange.getIn().getHeader("jsr356.session", Session.class);
        if (session != null && ((Boolean)exchange.getIn().getHeader("jsr356.producer.session.incoming.use", (Object)false, Boolean.class)).booleanValue()) {
            Session session2 = session;
            synchronized (session2) {
                this.doSend(exchange, callback, session);
            }
        } else {
            this.onExchange.accept(exchange, callback);
        }
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        URI uri = this.getEndpoint().getUri();
        if (uri.getScheme() != null && !uri.getScheme().equals("ws")) {
            throw new IllegalArgumentException("WebSocket endpoint URI must be in the format: websocket-jsr356:ws://host:port/path");
        }
        ClientEndpointConfig.Builder clientConfig = ClientEndpointConfig.Builder.create();
        this.manager = new ClientSessions(this.getEndpoint().getSessionCount(), uri, clientConfig.build(), null);
        this.manager.prepare();
        this.onExchange = (exchange, callback) -> this.manager.execute(session -> this.doSend((Exchange)exchange, (AsyncCallback)callback, (Session)session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(Exchange exchange, AsyncCallback callback, Session session) {
        try {
            Object body = exchange.getMessage().getBody();
            Session session2 = session;
            synchronized (session2) {
                RemoteEndpoint.Basic basicRemote = session.getBasicRemote();
                if (String.class.isInstance(body)) {
                    basicRemote.sendText(String.valueOf(body));
                } else if (ByteBuffer.class.isInstance(body)) {
                    basicRemote.sendBinary((ByteBuffer)ByteBuffer.class.cast(body));
                } else if (InputStream.class.isInstance(body)) {
                    IOHelper.copy((InputStream)((InputStream)InputStream.class.cast(body)), (OutputStream)basicRemote.getSendStream());
                } else {
                    throw new IllegalArgumentException("Unsupported input: " + body);
                }
            }
        }
        catch (IOException e) {
            exchange.setException((Throwable)e);
        }
        finally {
            callback.done(true);
        }
    }

    protected void doStop() throws Exception {
        Optional.ofNullable(this.manager).ifPresent(ClientSessions::close);
        super.doStop();
    }
}

