/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.lambda;

import com.amazonaws.Protocol;
import com.amazonaws.services.lambda.AWSLambda;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.lambda.LambdaComponent;
import org.apache.camel.component.aws.lambda.LambdaConfiguration;
import org.apache.camel.component.aws.lambda.LambdaOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class LambdaComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private LambdaConfiguration getOrCreateConfiguration(LambdaComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new LambdaConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        LambdaComponent target = (LambdaComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)LambdaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "awslambdaclient": 
            case "awsLambdaClient": {
                this.getOrCreateConfiguration(target).setAwsLambdaClient((AWSLambda)LambdaComponentConfigurer.property((CamelContext)camelContext, AWSLambda.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)LambdaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((LambdaConfiguration)LambdaComponentConfigurer.property((CamelContext)camelContext, LambdaConfiguration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)LambdaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((LambdaOperations)((Object)LambdaComponentConfigurer.property((CamelContext)camelContext, LambdaOperations.class, (Object)value)));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)LambdaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)LambdaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)LambdaComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)LambdaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)LambdaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("awsLambdaClient", AWSLambda.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("configuration", LambdaConfiguration.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("operation", LambdaOperations.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        LambdaComponent target = (LambdaComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "awslambdaclient": 
            case "awsLambdaClient": {
                return this.getOrCreateConfiguration(target).getAwsLambdaClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
        }
        return null;
    }
}

