/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.FormatFactories;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.format.factories.DefaultFactoryRegistry;
import org.apache.camel.dataformat.bindy.format.factories.FactoryRegistry;
import org.apache.camel.dataformat.bindy.format.factories.FormatFactoryInterface;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BindyAbstractDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(BindyAbstractDataFormat.class);
    private String locale;
    private BindyAbstractFactory modelFactory;
    private Class<?> classType;
    private CamelContext camelContext;
    private boolean unwrapSingleInstance = true;
    private boolean allowEmptyStream;

    public BindyAbstractDataFormat() {
    }

    protected BindyAbstractDataFormat(Class<?> classType) {
        this.classType = classType;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public void setClassType(Class<?> classType) {
        this.classType = classType;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public boolean isUnwrapSingleInstance() {
        return this.unwrapSingleInstance;
    }

    public void setUnwrapSingleInstance(boolean unwrapSingleInstance) {
        this.unwrapSingleInstance = unwrapSingleInstance;
    }

    public boolean isAllowEmptyStream() {
        return this.allowEmptyStream;
    }

    public void setAllowEmptyStream(boolean allowEmptyStream) {
        this.allowEmptyStream = allowEmptyStream;
    }

    public BindyAbstractFactory getFactory() throws Exception {
        if (this.modelFactory == null) {
            FormatFactory formatFactory = this.createFormatFactory();
            this.registerAdditionalConverter(formatFactory);
            this.modelFactory = this.createModelFactory(formatFactory);
            this.modelFactory.setLocale(this.locale);
        }
        return this.modelFactory;
    }

    private void registerAdditionalConverter(FormatFactory formatFactory) throws IllegalAccessException, InstantiationException {
        Function<Class, FormatFactories> g = aClass -> aClass.getAnnotation(FormatFactories.class);
        Function<FormatFactories, List> h = formatFactories -> Arrays.asList(formatFactories.value());
        List array = Optional.ofNullable(this.classType).map(g).map(h).orElse(Collections.emptyList());
        for (Class l : array) {
            formatFactory.getFactoryRegistry().register((FormatFactoryInterface)l.newInstance());
        }
    }

    private FormatFactory createFormatFactory() {
        FormatFactory formatFactory = new FormatFactory();
        FactoryRegistry factoryRegistry = this.createFactoryRegistry();
        formatFactory.setFactoryRegistry(factoryRegistry);
        return formatFactory;
    }

    private FactoryRegistry createFactoryRegistry() {
        return this.tryToGetFactoryRegistry();
    }

    private FactoryRegistry tryToGetFactoryRegistry() {
        Function<CamelContext, Registry> f = CamelContext::getRegistry;
        Function<Registry, Set> g = r -> r.findByType(FactoryRegistry.class);
        Function<Set, FactoryRegistry> h = factoryRegistries -> {
            if (factoryRegistries.size() > 1) {
                LOGGER.warn("Number of registered {}: {}", (Object)FactoryRegistry.class.getCanonicalName(), (Object)factoryRegistries.size());
            }
            if (factoryRegistries.iterator().hasNext()) {
                return (FactoryRegistry)factoryRegistries.iterator().next();
            }
            return new DefaultFactoryRegistry();
        };
        return Optional.ofNullable(this.camelContext).map(f).map(g).map(h).orElse(new DefaultFactoryRegistry());
    }

    public void setModelFactory(BindyAbstractFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    protected Map<String, Object> createLinkedFieldsModel(Object model) throws IllegalAccessException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        this.createLinkedFieldsModel(model, row);
        return row;
    }

    protected void createLinkedFieldsModel(Object model, Map<String, Object> row) throws IllegalAccessException {
        for (Field field : model.getClass().getDeclaredFields()) {
            Link linkField = field.getAnnotation(Link.class);
            if (linkField == null) continue;
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            if (!row.containsKey(field.getType().getName())) {
                row.put(field.getType().getName(), field.get(model));
            }
            field.setAccessible(accessible);
        }
    }

    protected abstract BindyAbstractFactory createModelFactory(FormatFactory var1) throws Exception;

    protected Object extractUnmarshalResult(List<Map<String, Object>> models) {
        if (this.getClassType() != null) {
            ArrayList<Object> answer = new ArrayList<Object>();
            for (Map<String, Object> entry : models) {
                Object data = entry.get(this.getClassType().getName());
                if (data == null) continue;
                answer.add(data);
            }
            if (this.isUnwrapSingleInstance() && answer.size() == 1) {
                return answer.get(0);
            }
            return answer;
        }
        return models;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

