/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.univocity;

import com.univocity.parsers.fixed.FixedWidthFields;
import com.univocity.parsers.fixed.FixedWidthFormat;
import com.univocity.parsers.fixed.FixedWidthParser;
import com.univocity.parsers.fixed.FixedWidthParserSettings;
import com.univocity.parsers.fixed.FixedWidthWriter;
import com.univocity.parsers.fixed.FixedWidthWriterSettings;
import java.io.Writer;
import java.util.LinkedHashMap;
import org.apache.camel.dataformat.univocity.AbstractUniVocityDataFormat;
import org.apache.camel.spi.annotations.Dataformat;

@Dataformat(value="univocity-fixed")
public class UniVocityFixedWidthDataFormat
extends AbstractUniVocityDataFormat<FixedWidthFormat, FixedWidthWriterSettings, FixedWidthWriter, FixedWidthParserSettings, FixedWidthParser, UniVocityFixedWidthDataFormat> {
    protected int[] fieldLengths;
    protected Boolean skipTrailingCharsUntilNewline;
    protected Boolean recordEndsOnNewline;
    protected Character padding;

    public int[] getFieldLengths() {
        return this.fieldLengths;
    }

    public UniVocityFixedWidthDataFormat setFieldLengths(int[] fieldLengths) {
        this.fieldLengths = fieldLengths;
        return this;
    }

    public Boolean getSkipTrailingCharsUntilNewline() {
        return this.skipTrailingCharsUntilNewline;
    }

    public UniVocityFixedWidthDataFormat setSkipTrailingCharsUntilNewline(Boolean skipTrailingCharsUntilNewline) {
        this.skipTrailingCharsUntilNewline = skipTrailingCharsUntilNewline;
        return this;
    }

    public Boolean getRecordEndsOnNewline() {
        return this.recordEndsOnNewline;
    }

    public UniVocityFixedWidthDataFormat setRecordEndsOnNewline(Boolean recordEndsOnNewline) {
        this.recordEndsOnNewline = recordEndsOnNewline;
        return this;
    }

    public Character getPadding() {
        return this.padding;
    }

    public UniVocityFixedWidthDataFormat setPadding(Character padding) {
        this.padding = padding;
        return this;
    }

    @Override
    protected FixedWidthWriterSettings createWriterSettings() {
        return new FixedWidthWriterSettings(this.createFixedWidthFields());
    }

    @Override
    protected FixedWidthWriter createWriter(Writer writer, FixedWidthWriterSettings settings) {
        return new FixedWidthWriter(writer, settings);
    }

    @Override
    protected FixedWidthParserSettings createParserSettings() {
        return new FixedWidthParserSettings(this.createFixedWidthFields());
    }

    @Override
    protected void configureParserSettings(FixedWidthParserSettings settings) {
        super.configureParserSettings(settings);
        if (this.skipTrailingCharsUntilNewline != null) {
            settings.setSkipTrailingCharsUntilNewline(this.skipTrailingCharsUntilNewline.booleanValue());
        }
        if (this.recordEndsOnNewline != null) {
            settings.setRecordEndsOnNewline(true);
        }
    }

    @Override
    protected FixedWidthParser createParser(FixedWidthParserSettings settings) {
        return new FixedWidthParser(settings);
    }

    @Override
    protected void configureFormat(FixedWidthFormat format) {
        super.configureFormat(format);
        if (this.padding != null) {
            format.setPadding(this.padding.charValue());
        }
    }

    private FixedWidthFields createFixedWidthFields() {
        if (this.fieldLengths == null) {
            throw new IllegalArgumentException("The fieldLengths must have been defined in order to use the fixed-width format.");
        }
        if (this.headers == null) {
            return new FixedWidthFields(this.fieldLengths);
        }
        if (this.fieldLengths.length != this.headers.length) {
            throw new IllegalArgumentException("The headers and fieldLengths must have the same number of element in order to use the fixed-width format.");
        }
        LinkedHashMap<String, Integer> fields = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < this.headers.length; ++i) {
            fields.put(this.headers[i], this.fieldLengths[i]);
        }
        if (fields.size() != this.headers.length) {
            throw new IllegalArgumentException("The headers cannot have duplicates in order to use the fixed-width format.");
        }
        return new FixedWidthFields(fields);
    }

    public String getDataFormatName() {
        return "univocity-fixed";
    }
}

