/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ldap;

import java.net.URISyntaxException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ldap.LdapComponent;
import org.apache.camel.component.ldap.LdapProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="1.5.0", scheme="ldap", title="LDAP", syntax="ldap:dirContextName", producerOnly=true, category={Category.SEARCH, Category.LDAP})
public class LdapEndpoint
extends DefaultEndpoint {
    public static final String SYSTEM_DN = "ou=system";
    public static final String OBJECT_SCOPE = "object";
    public static final String ONELEVEL_SCOPE = "onelevel";
    public static final String SUBTREE_SCOPE = "subtree";
    @UriPath
    @Metadata(required=true)
    private String dirContextName;
    @UriParam(defaultValue="ou=system")
    private String base = "ou=system";
    @UriParam(defaultValue="subtree", enums="object,onelevel,subtree")
    private String scope = "subtree";
    @UriParam
    private Integer pageSize;
    @UriParam
    private String returnedAttributes;

    protected LdapEndpoint(String endpointUri, String remaining, LdapComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.dirContextName = remaining;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("An LDAP Consumer would be the LDAP server itself! No such support here");
    }

    public Producer createProducer() throws Exception {
        return new LdapProducer(this, this.dirContextName, this.base, this.toSearchControlScope(this.scope), this.pageSize, this.returnedAttributes);
    }

    public String getDirContextName() {
        return this.dirContextName;
    }

    public void setDirContextName(String dirContextName) {
        this.dirContextName = dirContextName;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getReturnedAttributes() {
        return this.returnedAttributes;
    }

    public void setReturnedAttributes(String returnedAttributes) {
        this.returnedAttributes = returnedAttributes;
    }

    private int toSearchControlScope(String scope) {
        if (scope.equalsIgnoreCase(OBJECT_SCOPE)) {
            return 0;
        }
        if (scope.equalsIgnoreCase(ONELEVEL_SCOPE)) {
            return 1;
        }
        if (scope.equalsIgnoreCase(SUBTREE_SCOPE)) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid search scope \"" + scope + "\" for LdapEndpoint: " + this.getEndpointUri());
    }
}

