/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.micrometer.MicrometerEndpoint;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="micrometer")
public class MicrometerComponent
extends DefaultComponent {
    public static final Meter.Type DEFAULT_METER_TYPE = Meter.Type.COUNTER;
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerComponent.class);
    @Metadata(label="advanced")
    private MeterRegistry metricsRegistry;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (this.metricsRegistry == null) {
            Registry camelRegistry = this.getCamelContext().getRegistry();
            this.metricsRegistry = MicrometerUtils.getOrCreateMeterRegistry(camelRegistry, "metricsRegistry");
        }
        String metricsName = this.getMetricsName(remaining);
        Meter.Type metricsType = this.getMetricsType(remaining);
        Iterable<Tag> tags = this.getMetricsTag(parameters);
        LOG.debug("Metrics type: {}; name: {}; tags: {}", new Object[]{metricsType, metricsName, tags});
        MicrometerEndpoint endpoint = new MicrometerEndpoint(uri, (Component)this, this.metricsRegistry, metricsType, metricsName, tags);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    String getMetricsName(String remaining) {
        String name = StringHelper.after((String)remaining, (String)":");
        return name == null ? remaining : name;
    }

    Meter.Type getMetricsType(String remaining) {
        String type = StringHelper.before((String)remaining, (String)":");
        return type == null ? DEFAULT_METER_TYPE : MicrometerUtils.getByName(type);
    }

    Iterable<Tag> getMetricsTag(Map<String, Object> parameters) {
        String tagsString = (String)this.getAndRemoveParameter(parameters, "tags", String.class, "");
        if (tagsString != null && !tagsString.isEmpty()) {
            String[] tagStrings = tagsString.split("\\s*,\\s*");
            return (Iterable)Stream.of(tagStrings).map(s -> Tags.of((String[])s.split("\\s*=\\s*"))).reduce(Tags.empty(), Tags::and);
        }
        return Tags.empty();
    }

    public MeterRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void setMetricsRegistry(MeterRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }
}

