/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ganglia;

import info.ganglia.gmetric4j.Publisher;
import info.ganglia.gmetric4j.gmetric.GMetric;
import info.ganglia.gmetric4j.gmetric.GMetricPublisher;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ganglia.GangliaConfiguration;
import org.apache.camel.component.ganglia.GangliaProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.15.0", scheme="ganglia", title="Ganglia", syntax="ganglia:host:port", producerOnly=true, category={Category.MONITORING})
public class GangliaEndpoint
extends DefaultEndpoint {
    private Publisher publisher;
    @UriParam
    private GangliaConfiguration configuration;

    public GangliaEndpoint() {
    }

    public GangliaEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        return new GangliaProducer(this, this.getPublisher());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Ganglia consumer not supported");
    }

    public GangliaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GangliaConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized Publisher getPublisher() {
        if (this.publisher == null) {
            GMetric gmetric = this.configuration.createGMetric();
            this.publisher = new GMetricPublisher(gmetric);
        }
        return this.publisher;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }
}

