/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.utils.message.PulsarMessageUtils;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarMessageListener
implements MessageListener<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarMessageListener.class);
    private final PulsarEndpoint endpoint;
    private final PulsarConsumer pulsarConsumer;

    public PulsarMessageListener(PulsarEndpoint endpoint, PulsarConsumer pulsarConsumer) {
        this.endpoint = endpoint;
        this.pulsarConsumer = pulsarConsumer;
    }

    public void received(Consumer<byte[]> consumer, Message<byte[]> message) {
        Exchange exchange = PulsarMessageUtils.updateExchange(message, this.endpoint.createExchange());
        try {
            if (this.endpoint.getPulsarConfiguration().isAllowManualAcknowledgement()) {
                exchange.getIn().setHeader("message_receipt", (Object)this.endpoint.getComponent().getPulsarMessageReceiptFactory().newInstance(exchange, message, consumer));
            }
            if (this.endpoint.isSynchronous()) {
                this.process(exchange, consumer, message);
            } else {
                this.processAsync(exchange, consumer, message);
            }
        }
        catch (Exception exception) {
            this.handleProcessorException(exchange, exception);
        }
    }

    private void process(Exchange exchange, Consumer<byte[]> consumer, Message<byte[]> message) throws Exception {
        this.pulsarConsumer.getProcessor().process(exchange);
        this.acknowledge(consumer, message);
    }

    private void processAsync(final Exchange exchange, final Consumer<byte[]> consumer, final Message<byte[]> message) {
        this.pulsarConsumer.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    PulsarMessageListener.this.handleProcessorException(exchange, exchange.getException());
                } else {
                    try {
                        PulsarMessageListener.this.acknowledge((Consumer<byte[]>)consumer, (Message<byte[]>)message);
                    }
                    catch (Exception e) {
                        PulsarMessageListener.this.handleProcessorException(exchange, e);
                    }
                }
            }
        });
    }

    private void acknowledge(Consumer<byte[]> consumer, Message<byte[]> message) throws PulsarClientException {
        if (!this.endpoint.getPulsarConfiguration().isAllowManualAcknowledgement()) {
            consumer.acknowledge(message.getMessageId());
        }
    }

    private void handleProcessorException(Exchange exchange, Exception exception) {
        Exchange exchangeWithException = PulsarMessageUtils.updateExchangeWithException(exception, exchange);
        this.pulsarConsumer.getExceptionHandler().handleException("An error occurred", exchangeWithException, (Throwable)exception);
    }
}

