/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.common;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import org.apache.camel.spi.UriParam;

public abstract class AbstractConfiguration
implements Cloneable {
    @UriParam
    private StorageCredentials credentials;
    @UriParam(label="security", secret=true)
    private String credentialsAccountKey;
    @UriParam(label="security", secret=true)
    private String credentialsAccountName;
    @UriParam(defaultValue="true")
    private boolean validateClientURI = true;
    private String accountName;

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public StorageCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }

    public String getCredentialsAccountKey() {
        return this.credentialsAccountKey;
    }

    public void setCredentialsAccountKey(String credentialsAccountKey) {
        this.credentialsAccountKey = credentialsAccountKey;
    }

    public String getCredentialsAccountName() {
        return this.credentialsAccountName;
    }

    public void setCredentialsAccountName(String credentialsAccountName) {
        this.credentialsAccountName = credentialsAccountName;
    }

    public StorageCredentials getAccountCredentials() {
        StorageCredentials creds = this.credentials;
        if (creds == null && this.credentialsAccountKey != null && this.credentialsAccountName != null) {
            creds = new StorageCredentialsAccountAndKey(this.credentialsAccountName, this.credentialsAccountKey);
        }
        return creds;
    }

    public boolean isValidateClientURI() {
        return this.validateClientURI;
    }

    public void setValidateClientURI(boolean validateClientURI) {
        this.validateClientURI = validateClientURI;
    }
}

