/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.azure.blob.BlobServiceEndpoint;
import org.apache.camel.component.azure.blob.BlobServiceOperations;
import org.apache.camel.component.azure.blob.BlobType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class BlobServiceEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        BlobServiceEndpoint target = (BlobServiceEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "azureblobclient": 
            case "azureBlobClient": {
                target.getConfiguration().setAzureBlobClient((CloudBlob)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, CloudBlob.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "blobmetadata": 
            case "blobMetadata": {
                target.getConfiguration().setBlobMetadata((Map)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "bloboffset": 
            case "blobOffset": {
                target.getConfiguration().setBlobOffset((Long)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "blobprefix": 
            case "blobPrefix": {
                target.getConfiguration().setBlobPrefix((String)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "blobtype": 
            case "blobType": {
                target.getConfiguration().setBlobType((BlobType)((Object)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, BlobType.class, (Object)value)));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                target.getConfiguration().setCloseStreamAfterRead((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                target.getConfiguration().setCloseStreamAfterWrite((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "credentials": {
                target.getConfiguration().setCredentials((StorageCredentials)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, StorageCredentials.class, (Object)value));
                return true;
            }
            case "credentialsaccountkey": 
            case "credentialsAccountKey": {
                target.getConfiguration().setCredentialsAccountKey((String)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "credentialsaccountname": 
            case "credentialsAccountName": {
                target.getConfiguration().setCredentialsAccountName((String)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "datalength": 
            case "dataLength": {
                target.getConfiguration().setDataLength((Long)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "filedir": 
            case "fileDir": {
                target.getConfiguration().setFileDir((String)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                target.getConfiguration().setOperation((BlobServiceOperations)((Object)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, BlobServiceOperations.class, (Object)value)));
                return true;
            }
            case "publicforread": 
            case "publicForRead": {
                target.getConfiguration().setPublicForRead((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "streamreadsize": 
            case "streamReadSize": {
                target.getConfiguration().setStreamReadSize((Integer)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "streamwritesize": 
            case "streamWriteSize": {
                target.getConfiguration().setStreamWriteSize((Integer)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useflatlisting": 
            case "useFlatListing": {
                target.getConfiguration().setUseFlatListing((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "validateclienturi": 
            case "validateClientURI": {
                target.getConfiguration().setValidateClientURI((Boolean)BlobServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("azureBlobClient", CloudBlob.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("blobMetadata", Map.class);
        answer.put("blobOffset", Long.class);
        answer.put("blobPrefix", String.class);
        answer.put("blobType", BlobType.class);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("closeStreamAfterRead", Boolean.TYPE);
        answer.put("closeStreamAfterWrite", Boolean.TYPE);
        answer.put("credentials", StorageCredentials.class);
        answer.put("credentialsAccountKey", String.class);
        answer.put("credentialsAccountName", String.class);
        answer.put("dataLength", Long.class);
        answer.put("exceptionHandler", ExceptionHandler.class);
        answer.put("exchangePattern", ExchangePattern.class);
        answer.put("fileDir", String.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("operation", BlobServiceOperations.class);
        answer.put("publicForRead", Boolean.TYPE);
        answer.put("streamReadSize", Integer.TYPE);
        answer.put("streamWriteSize", Integer.TYPE);
        answer.put("synchronous", Boolean.TYPE);
        answer.put("useFlatListing", Boolean.TYPE);
        answer.put("validateClientURI", Boolean.TYPE);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        BlobServiceEndpoint target = (BlobServiceEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "azureblobclient": 
            case "azureBlobClient": {
                return target.getConfiguration().getAzureBlobClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "blobmetadata": 
            case "blobMetadata": {
                return target.getConfiguration().getBlobMetadata();
            }
            case "bloboffset": 
            case "blobOffset": {
                return target.getConfiguration().getBlobOffset();
            }
            case "blobprefix": 
            case "blobPrefix": {
                return target.getConfiguration().getBlobPrefix();
            }
            case "blobtype": 
            case "blobType": {
                return target.getConfiguration().getBlobType();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return target.getConfiguration().isCloseStreamAfterRead();
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                return target.getConfiguration().isCloseStreamAfterWrite();
            }
            case "credentials": {
                return target.getConfiguration().getCredentials();
            }
            case "credentialsaccountkey": 
            case "credentialsAccountKey": {
                return target.getConfiguration().getCredentialsAccountKey();
            }
            case "credentialsaccountname": 
            case "credentialsAccountName": {
                return target.getConfiguration().getCredentialsAccountName();
            }
            case "datalength": 
            case "dataLength": {
                return target.getConfiguration().getDataLength();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "filedir": 
            case "fileDir": {
                return target.getConfiguration().getFileDir();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return target.getConfiguration().getOperation();
            }
            case "publicforread": 
            case "publicForRead": {
                return target.getConfiguration().isPublicForRead();
            }
            case "streamreadsize": 
            case "streamReadSize": {
                return target.getConfiguration().getStreamReadSize();
            }
            case "streamwritesize": 
            case "streamWriteSize": {
                return target.getConfiguration().getStreamWriteSize();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "useflatlisting": 
            case "useFlatListing": {
                return target.getConfiguration().isUseFlatListing();
            }
            case "validateclienturi": 
            case "validateClientURI": {
                return target.getConfiguration().isValidateClientURI();
            }
        }
        return null;
    }
}

