/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.client;

import java.time.Instant;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.client.ClientConnection;
import org.apache.camel.component.iec60870.client.ClientEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ClientConsumer.class);
    private final ClientConnection connection;
    private final ClientEndpoint endpoint;

    public ClientConsumer(ClientEndpoint endpoint, Processor processor, ClientConnection connection) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.connection = connection;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connection.setListener(this.endpoint.getAddress(), this::updateValue);
    }

    protected void doStop() throws Exception {
        this.connection.setListener(this.endpoint.getAddress(), null);
        super.doStop();
    }

    private void updateValue(ObjectAddress address, Value<?> value) {
        try {
            Exchange exchange = this.getEndpoint().createExchange();
            exchange.setIn(this.mapMessage(value));
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.debug("Failed to process message", (Throwable)e);
        }
    }

    private Message mapMessage(Value<?> value) {
        DefaultMessage message = new DefaultMessage(this.endpoint.getCamelContext());
        message.setBody(value);
        message.setHeader("value", value.getValue());
        message.setHeader("timestamp", (Object)Instant.ofEpochMilli(value.getTimestamp()));
        message.setHeader("quality", (Object)value.getQualityInformation());
        message.setHeader("overflow", (Object)value.isOverflow());
        return message;
    }
}

