/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerConfiguration;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.apache.camel.util.ObjectHelper;

public final class VertxPlatformHttpServerSupport {
    private static final Pattern COMMA_SEPARATED_SPLIT_REGEX = Pattern.compile("\\s*,\\s*");

    private VertxPlatformHttpServerSupport() {
    }

    static Handler<RoutingContext> createBodyHandler(VertxPlatformHttpServerConfiguration configuration) {
        final BodyHandler bodyHandler = BodyHandler.create();
        if (configuration.getMaxBodySize() != null) {
            bodyHandler.setBodyLimit(configuration.getMaxBodySize().longValueExact());
        }
        bodyHandler.setHandleFileUploads(configuration.getBodyHandler().isHandleFileUploads());
        bodyHandler.setUploadsDirectory(configuration.getBodyHandler().getUploadsDirectory());
        bodyHandler.setDeleteUploadedFilesOnEnd(configuration.getBodyHandler().isDeleteUploadedFilesOnEnd());
        bodyHandler.setMergeFormAttributes(configuration.getBodyHandler().isMergeFormAttributes());
        bodyHandler.setPreallocateBodyBuffer(configuration.getBodyHandler().isPreallocateBodyBuffer());
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                event.request().resume();
                bodyHandler.handle((Object)event);
            }
        };
    }

    static Handler<RoutingContext> createCorsHandler(VertxPlatformHttpServerConfiguration configuration) {
        final VertxPlatformHttpServerConfiguration.Cors corsConfig = configuration.getCors();
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                HttpServerRequest request = event.request();
                HttpServerResponse response = event.response();
                String origin = request.getHeader(HttpHeaders.ORIGIN);
                if (origin == null) {
                    event.next();
                } else {
                    boolean allowsOrigin;
                    String requestedHeaders;
                    String requestedMethods = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD);
                    if (requestedMethods != null) {
                        VertxPlatformHttpServerSupport.processHeaders(response, HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, requestedMethods, corsConfig.getMethods());
                    }
                    if ((requestedHeaders = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
                        VertxPlatformHttpServerSupport.processHeaders(response, HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, requestedHeaders, corsConfig.getHeaders());
                    }
                    boolean bl = allowsOrigin = ObjectHelper.isEmpty(corsConfig.getOrigins()) || corsConfig.getOrigins().contains(origin);
                    if (allowsOrigin) {
                        response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
                    }
                    response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)"true");
                    if (ObjectHelper.isNotEmpty(corsConfig.getExposedHeaders())) {
                        response.headers().set(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, (CharSequence)String.join((CharSequence)",", corsConfig.getExposedHeaders()));
                    }
                    if (request.method().equals((Object)HttpMethod.OPTIONS)) {
                        if ((requestedHeaders != null || requestedMethods != null) && corsConfig.getAccessControlMaxAge() != null) {
                            response.putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)String.valueOf(corsConfig.getAccessControlMaxAge().getSeconds()));
                        }
                        response.end();
                    } else {
                        event.next();
                    }
                }
            }
        };
    }

    private static void processHeaders(HttpServerResponse response, CharSequence header, String allowValues, Collection<String> values) {
        if (ObjectHelper.isEmpty(values)) {
            response.headers().set(header, (CharSequence)allowValues);
        } else {
            HashSet<String> requestedValues = new HashSet<String>();
            for (String requestedValue : COMMA_SEPARATED_SPLIT_REGEX.split(allowValues)) {
                requestedValues.add(requestedValue.toLowerCase());
            }
            String result = values.stream().filter(value -> requestedValues.contains(value.toLowerCase())).collect(Collectors.joining(","));
            if (ObjectHelper.isNotEmpty((Object)result)) {
                response.headers().set(header, (CharSequence)result);
            }
        }
    }

    static HttpServerOptions configureSSL(HttpServerOptions options, VertxPlatformHttpServerConfiguration configuration, final CamelContext camelContext) {
        SSLContextParameters sslParameters;
        Object object = configuration.getSslContextParameters() != null ? configuration.getSslContextParameters() : (sslParameters = configuration.isUseGlobalSslContextParameters() ? camelContext.getSSLContextParameters() : null);
        if (sslParameters != null) {
            options.setSsl(true);
            options.setKeyCertOptions(new KeyCertOptions(){

                public KeyManagerFactory getKeyManagerFactory(Vertx vertx) throws Exception {
                    return VertxPlatformHttpServerSupport.createKeyManagerFactory(camelContext, sslParameters);
                }

                public KeyCertOptions clone() {
                    return this;
                }
            });
            options.setTrustOptions(new TrustOptions(){

                public TrustOptions clone() {
                    return this;
                }

                public TrustManagerFactory getTrustManagerFactory(Vertx vertx) throws Exception {
                    return VertxPlatformHttpServerSupport.createTrustManagerFactory(camelContext, sslParameters);
                }
            });
        }
        return options;
    }

    private static KeyManagerFactory createKeyManagerFactory(CamelContext camelContext, SSLContextParameters sslContextParameters) throws GeneralSecurityException, IOException {
        KeyManagersParameters keyManagers = sslContextParameters.getKeyManagers();
        if (keyManagers == null) {
            return null;
        }
        String kmfAlgorithm = camelContext.resolvePropertyPlaceholders(keyManagers.getAlgorithm());
        if (kmfAlgorithm == null) {
            kmfAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        KeyManagerFactory kmf = keyManagers.getProvider() == null ? KeyManagerFactory.getInstance(kmfAlgorithm) : KeyManagerFactory.getInstance(kmfAlgorithm, camelContext.resolvePropertyPlaceholders(keyManagers.getProvider()));
        char[] kmfPassword = null;
        if (keyManagers.getKeyPassword() != null) {
            kmfPassword = camelContext.resolvePropertyPlaceholders(keyManagers.getKeyPassword()).toCharArray();
        }
        KeyStore ks = keyManagers.getKeyStore() == null ? null : keyManagers.getKeyStore().createKeyStore();
        kmf.init(ks, kmfPassword);
        return kmf;
    }

    private static TrustManagerFactory createTrustManagerFactory(CamelContext camelContext, SSLContextParameters sslContextParameters) throws GeneralSecurityException, IOException {
        TrustManagersParameters trustManagers = sslContextParameters.getTrustManagers();
        if (trustManagers == null) {
            return null;
        }
        TrustManagerFactory tmf = null;
        if (trustManagers.getKeyStore() != null) {
            String tmfAlgorithm = camelContext.resolvePropertyPlaceholders(trustManagers.getAlgorithm());
            if (tmfAlgorithm == null) {
                tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            tmf = trustManagers.getProvider() == null ? TrustManagerFactory.getInstance(tmfAlgorithm) : TrustManagerFactory.getInstance(tmfAlgorithm, camelContext.resolvePropertyPlaceholders(trustManagers.getProvider()));
            KeyStore ks = trustManagers.getKeyStore() == null ? null : trustManagers.getKeyStore().createKeyStore();
            tmf.init(ks);
        }
        return tmf;
    }
}

