/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.api;

import java.security.InvalidKeyException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureInvalidContentHashException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureInvalidKeyException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureInvalidValueException;

public class DefaultValidationFailedHandler
implements ValidationFailedHandler {
    private StringBuilder error;

    @Override
    public Exception onXMLSignatureException(XMLSignatureException se) {
        if (se.getCause() instanceof InvalidKeyException) {
            return new XmlSignatureInvalidKeyException(se);
        }
        return new XmlSignatureException(se);
    }

    @Override
    public void start() {
        this.error = new StringBuilder();
        this.error.append("Signature validation failed. ");
    }

    @Override
    public void signatureValueValidationFailed(XMLSignature.SignatureValue value) throws Exception {
        this.error.append("The signature value could not be validated by the public key. Either the message has been tampered with or the public key is not correct.");
        throw new XmlSignatureInvalidValueException(this.error.toString());
    }

    @Override
    public void referenceValidationFailed(Reference ref) throws Exception {
        this.error.append(String.format("The calculated digest value of the document  %s is not equal to the value specified in the XML signature. The document may have been tampered with.", this.getReferenceUriOrId(ref)));
        throw new XmlSignatureInvalidContentHashException(this.error.toString());
    }

    @Override
    public void manifestReferenceValidationFailed(Reference ref) throws Exception {
        this.error.append(String.format("The calculated digest value of the manifest  %s is not equal to the value specified in the XML signature. The document may have been tampered with.", this.getReferenceUriOrId(ref)));
        throw new XmlSignatureInvalidContentHashException(this.error.toString());
    }

    @Override
    public void end() throws Exception {
        this.error = null;
    }

    private String getReferenceUriOrId(Reference ref) {
        String docId = ref.getURI();
        if (docId == null) {
            docId = ref.getId();
        }
        return docId;
    }

    @Override
    public boolean ignoreCoreValidationFailure() throws Exception {
        return false;
    }
}

