/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import java.util.Map;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.URIDereferencer;
import org.apache.camel.CamelContext;
import org.apache.camel.component.xmlsecurity.XmlVerifierComponent;
import org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler;
import org.apache.camel.component.xmlsecurity.api.XmlSignature2Message;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureChecker;
import org.apache.camel.component.xmlsecurity.processor.XmlVerifierConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class XmlVerifierComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private XmlVerifierConfiguration getOrCreateConfiguration(XmlVerifierComponent target) {
        if (target.getVerifierConfiguration() == null) {
            target.setVerifierConfiguration(new XmlVerifierConfiguration());
        }
        return target.getVerifierConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        XmlVerifierComponent target = (XmlVerifierComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "baseuri": 
            case "baseUri": {
                this.getOrCreateConfiguration(target).setBaseUri((String)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "clearheaders": 
            case "clearHeaders": {
                this.getOrCreateConfiguration(target).setClearHeaders((Boolean)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "cryptocontextproperties": 
            case "cryptoContextProperties": {
                this.getOrCreateConfiguration(target).setCryptoContextProperties((Map)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "disallowdoctypedecl": 
            case "disallowDoctypeDecl": {
                this.getOrCreateConfiguration(target).setDisallowDoctypeDecl((Boolean)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "keyselector": 
            case "keySelector": {
                this.getOrCreateConfiguration(target).setKeySelector((KeySelector)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, KeySelector.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "omitxmldeclaration": 
            case "omitXmlDeclaration": {
                this.getOrCreateConfiguration(target).setOmitXmlDeclaration((Boolean)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "outputnodesearch": 
            case "outputNodeSearch": {
                this.getOrCreateConfiguration(target).setOutputNodeSearch(XmlVerifierComponentConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "outputnodesearchtype": 
            case "outputNodeSearchType": {
                this.getOrCreateConfiguration(target).setOutputNodeSearchType((String)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "outputxmlencoding": 
            case "outputXmlEncoding": {
                this.getOrCreateConfiguration(target).setOutputXmlEncoding((String)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "removesignatureelements": 
            case "removeSignatureElements": {
                this.getOrCreateConfiguration(target).setRemoveSignatureElements((Boolean)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "schemaresourceuri": 
            case "schemaResourceUri": {
                this.getOrCreateConfiguration(target).setSchemaResourceUri((String)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securevalidation": 
            case "secureValidation": {
                this.getOrCreateConfiguration(target).setSecureValidation((Boolean)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "uridereferencer": 
            case "uriDereferencer": {
                this.getOrCreateConfiguration(target).setUriDereferencer((URIDereferencer)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, URIDereferencer.class, (Object)value));
                return true;
            }
            case "validationfailedhandler": 
            case "validationFailedHandler": {
                this.getOrCreateConfiguration(target).setValidationFailedHandler((ValidationFailedHandler)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, ValidationFailedHandler.class, (Object)value));
                return true;
            }
            case "verifierconfiguration": 
            case "verifierConfiguration": {
                target.setVerifierConfiguration((XmlVerifierConfiguration)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, XmlVerifierConfiguration.class, (Object)value));
                return true;
            }
            case "xmlsignature2message": 
            case "xmlSignature2Message": {
                this.getOrCreateConfiguration(target).setXmlSignature2Message((XmlSignature2Message)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, XmlSignature2Message.class, (Object)value));
                return true;
            }
            case "xmlsignaturechecker": 
            case "xmlSignatureChecker": {
                this.getOrCreateConfiguration(target).setXmlSignatureChecker((XmlSignatureChecker)XmlVerifierComponentConfigurer.property((CamelContext)camelContext, XmlSignatureChecker.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("baseUri", String.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("clearHeaders", Boolean.class);
        answer.put("cryptoContextProperties", Map.class);
        answer.put("disallowDoctypeDecl", Boolean.class);
        answer.put("keySelector", KeySelector.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("omitXmlDeclaration", Boolean.class);
        answer.put("outputNodeSearch", Object.class);
        answer.put("outputNodeSearchType", String.class);
        answer.put("outputXmlEncoding", String.class);
        answer.put("removeSignatureElements", Boolean.class);
        answer.put("schemaResourceUri", String.class);
        answer.put("secureValidation", Boolean.class);
        answer.put("uriDereferencer", URIDereferencer.class);
        answer.put("validationFailedHandler", ValidationFailedHandler.class);
        answer.put("verifierConfiguration", XmlVerifierConfiguration.class);
        answer.put("xmlSignature2Message", XmlSignature2Message.class);
        answer.put("xmlSignatureChecker", XmlSignatureChecker.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        XmlVerifierComponent target = (XmlVerifierComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "baseuri": 
            case "baseUri": {
                return this.getOrCreateConfiguration(target).getBaseUri();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "clearheaders": 
            case "clearHeaders": {
                return this.getOrCreateConfiguration(target).getClearHeaders();
            }
            case "cryptocontextproperties": 
            case "cryptoContextProperties": {
                return this.getOrCreateConfiguration(target).getCryptoContextProperties();
            }
            case "disallowdoctypedecl": 
            case "disallowDoctypeDecl": {
                return this.getOrCreateConfiguration(target).getDisallowDoctypeDecl();
            }
            case "keyselector": 
            case "keySelector": {
                return this.getOrCreateConfiguration(target).getKeySelector();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "omitxmldeclaration": 
            case "omitXmlDeclaration": {
                return this.getOrCreateConfiguration(target).getOmitXmlDeclaration();
            }
            case "outputnodesearch": 
            case "outputNodeSearch": {
                return this.getOrCreateConfiguration(target).getOutputNodeSearch();
            }
            case "outputnodesearchtype": 
            case "outputNodeSearchType": {
                return this.getOrCreateConfiguration(target).getOutputNodeSearchType();
            }
            case "outputxmlencoding": 
            case "outputXmlEncoding": {
                return this.getOrCreateConfiguration(target).getOutputXmlEncoding();
            }
            case "removesignatureelements": 
            case "removeSignatureElements": {
                return this.getOrCreateConfiguration(target).getRemoveSignatureElements();
            }
            case "schemaresourceuri": 
            case "schemaResourceUri": {
                return this.getOrCreateConfiguration(target).getSchemaResourceUri();
            }
            case "securevalidation": 
            case "secureValidation": {
                return this.getOrCreateConfiguration(target).getSecureValidation();
            }
            case "uridereferencer": 
            case "uriDereferencer": {
                return this.getOrCreateConfiguration(target).getUriDereferencer();
            }
            case "validationfailedhandler": 
            case "validationFailedHandler": {
                return this.getOrCreateConfiguration(target).getValidationFailedHandler();
            }
            case "verifierconfiguration": 
            case "verifierConfiguration": {
                return target.getVerifierConfiguration();
            }
            case "xmlsignature2message": 
            case "xmlSignature2Message": {
                return this.getOrCreateConfiguration(target).getXmlSignature2Message();
            }
            case "xmlsignaturechecker": 
            case "xmlSignatureChecker": {
                return this.getOrCreateConfiguration(target).getXmlSignatureChecker();
            }
        }
        return null;
    }
}

