/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4.api.batch;

import java.util.Map;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchRequest;
import org.apache.camel.component.olingo4.api.batch.Operation;

public class Olingo4BatchChangeRequest
extends Olingo4BatchRequest {
    protected String contentId;
    protected Operation operation;
    protected Object body;

    public Operation getOperation() {
        return this.operation;
    }

    public Object getBody() {
        return this.body;
    }

    public String getContentId() {
        return this.contentId;
    }

    @Override
    public String toString() {
        return "Batch Change Request{ " + this.resourceUri + "/" + this.resourcePath + ", headers=" + this.headers + ", contentId=" + this.contentId + ", operation=" + (Object)((Object)this.operation) + ", body=" + this.body + '}';
    }

    public static Olingo4BatchChangeRequestBuilder resourcePath(String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("resourcePath");
        }
        return new Olingo4BatchChangeRequestBuilder().resourcePath(resourcePath);
    }

    public static class Olingo4BatchChangeRequestBuilder {
        private Olingo4BatchChangeRequest request = new Olingo4BatchChangeRequest();

        public Olingo4BatchChangeRequestBuilder resourcePath(String resourcePath) {
            this.request.resourcePath = resourcePath;
            return this;
        }

        public Olingo4BatchChangeRequestBuilder resourceUri(String resourceUri) {
            this.request.resourceUri = resourceUri;
            return this;
        }

        public Olingo4BatchChangeRequestBuilder headers(Map<String, String> headers) {
            this.request.headers = headers;
            return this;
        }

        public Olingo4BatchChangeRequestBuilder contentId(String contentId) {
            this.request.contentId = contentId;
            return this;
        }

        public Olingo4BatchChangeRequestBuilder operation(Operation operation) {
            this.request.operation = operation;
            return this;
        }

        public Olingo4BatchChangeRequestBuilder body(Object body) {
            this.request.body = body;
            return this;
        }

        public Olingo4BatchChangeRequest build() {
            if (this.request.resourcePath == null) {
                throw new IllegalArgumentException("Null resourcePath");
            }
            if (this.request.operation == null) {
                throw new IllegalArgumentException("Null operation");
            }
            if (this.request.operation != Operation.DELETE && this.request.body == null) {
                throw new IllegalArgumentException("Null body");
            }
            return this.request;
        }
    }
}

