/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack.io;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import org.apache.camel.component.lumberjack.io.LumberjackMessage;
import org.apache.camel.component.lumberjack.io.LumberjackMessageProcessor;
import org.apache.camel.component.lumberjack.io.LumberjackSessionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LumberjackMessageHandler
extends SimpleChannelInboundHandler<LumberjackMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(LumberjackMessageHandler.class);
    private final LumberjackSessionHandler sessionHandler;
    private final LumberjackMessageProcessor messageProcessor;
    private volatile boolean process = true;

    LumberjackMessageHandler(LumberjackSessionHandler sessionHandler, LumberjackMessageProcessor messageProcessor) {
        this.sessionHandler = sessionHandler;
        this.messageProcessor = messageProcessor;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            LOG.debug("IO exception (client connection closed ?)", cause);
        } else {
            LOG.warn("Caught an exception while reading, closing channel.", cause);
        }
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, LumberjackMessage msg) throws Exception {
        if (this.process) {
            this.messageProcessor.onMessageReceived(msg.getPayload(), success -> {
                if (success) {
                    this.sessionHandler.notifyMessageProcessed(ctx, msg.getSequenceNumber());
                } else {
                    ctx.close();
                    this.process = false;
                }
            });
        }
    }
}

