/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.streaming;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;

public class CometDReplayExtension
extends ClientSession.Extension.Adapter {
    private static final String EXTENSION_NAME = "replay";
    private final ConcurrentMap<String, Long> dataMap = new ConcurrentHashMap<String, Long>();
    private final AtomicBoolean supported = new AtomicBoolean();

    public void addChannelReplayId(String channelName, long replayId) {
        this.dataMap.put(channelName, replayId);
    }

    public boolean rcv(ClientSession session, Message.Mutable message) {
        Object value = message.get((Object)EXTENSION_NAME);
        Long replayId = value instanceof Long ? (Long)value : (value instanceof Number ? Long.valueOf(((Number)value).longValue()) : null);
        if (this.supported.get() && replayId != null) {
            try {
                this.dataMap.put(message.getChannel(), replayId);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return true;
    }

    public boolean rcvMeta(ClientSession session, Message.Mutable message) {
        switch (message.getChannel()) {
            case "/meta/handshake": {
                Map ext = message.getExt(false);
                this.supported.set(ext != null && Boolean.TRUE.equals(ext.get(EXTENSION_NAME)));
                break;
            }
        }
        return true;
    }

    public boolean sendMeta(ClientSession session, Message.Mutable message) {
        switch (message.getChannel()) {
            case "/meta/handshake": {
                message.getExt(true).put(EXTENSION_NAME, Boolean.TRUE);
                break;
            }
            case "/meta/subscribe": {
                if (!this.supported.get()) break;
                message.getExt(true).put(EXTENSION_NAME, this.dataMap);
                break;
            }
        }
        return true;
    }
}

