/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.component.salesforce.api.TypeReferences;

@JsonDeserialize(using=LimitsDeserializer.class)
public final class Limits
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Usage UNDEFINED = new Usage(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private final Map<String, Usage> usages;

    public Limits(Map<?, Usage> usages) {
        this.usages = usages == null ? new HashMap<String, Usage>() : usages.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
    }

    public Usage forOperation(Operation operation) {
        return this.usages.getOrDefault((Object)operation, UNDEFINED);
    }

    public Usage forOperation(String name) {
        return this.usages.getOrDefault(name, UNDEFINED);
    }

    public Usage getConcurrentAsyncGetReportInstances() {
        return this.forOperation(Operation.ConcurrentAsyncGetReportInstances.name());
    }

    public Usage getConcurrentSyncReportRuns() {
        return this.forOperation(Operation.ConcurrentSyncReportRuns.name());
    }

    public Usage getDailyApiRequests() {
        return this.forOperation(Operation.DailyApiRequests.name());
    }

    public Usage getDailyAsyncApexExecutions() {
        return this.forOperation(Operation.DailyAsyncApexExecutions.name());
    }

    public Usage getDailyBulkApiRequests() {
        return this.forOperation(Operation.DailyBulkApiRequests.name());
    }

    public Usage getDailyDurableGenericStreamingApiEvents() {
        return this.forOperation(Operation.DailyDurableGenericStreamingApiEvents.name());
    }

    public Usage getDailyDurableStreamingApiEvents() {
        return this.forOperation(Operation.DailyDurableStreamingApiEvents.name());
    }

    public Usage getDailyGenericStreamingApiEvents() {
        return this.forOperation(Operation.DailyGenericStreamingApiEvents.name());
    }

    public Usage getDailyStreamingApiEvents() {
        return this.forOperation(Operation.DailyStreamingApiEvents.name());
    }

    public Usage getDailyWorkflowEmails() {
        return this.forOperation(Operation.DailyWorkflowEmails.name());
    }

    public Usage getDataStorageMB() {
        return this.forOperation(Operation.DataStorageMB.name());
    }

    public Usage getDurableStreamingApiConcurrentClients() {
        return this.forOperation(Operation.DurableStreamingApiConcurrentClients.name());
    }

    public Usage getFileStorageMB() {
        return this.forOperation(Operation.FileStorageMB.name());
    }

    public Usage getHourlyAsyncReportRuns() {
        return this.forOperation(Operation.HourlyAsyncReportRuns.name());
    }

    public Usage getHourlyDashboardRefreshes() {
        return this.forOperation(Operation.HourlyDashboardRefreshes.name());
    }

    public Usage getHourlyDashboardResults() {
        return this.forOperation(Operation.HourlyDashboardResults.name());
    }

    public Usage getHourlyDashboardStatuses() {
        return this.forOperation(Operation.HourlyDashboardStatuses.name());
    }

    public Usage getHourlyODataCallout() {
        return this.forOperation(Operation.HourlyODataCallout.name());
    }

    public Usage getHourlySyncReportRuns() {
        return this.forOperation(Operation.HourlySyncReportRuns.name());
    }

    public Usage getHourlyTimeBasedWorkflow() {
        return this.forOperation(Operation.HourlyTimeBasedWorkflow.name());
    }

    public Usage getMassEmail() {
        return this.forOperation(Operation.MassEmail.name());
    }

    public Usage getPermissionSets() {
        return this.forOperation(Operation.PermissionSets.name());
    }

    public Usage getSingleEmail() {
        return this.forOperation(Operation.SingleEmail.name());
    }

    public Usage getStreamingApiConcurrentClients() {
        return this.forOperation(Operation.StreamingApiConcurrentClients.name());
    }

    public String toString() {
        return "Limits: " + this.usages.entrySet().stream().map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", "));
    }

    public static final class Usage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int UNKNOWN_VAL = Integer.MIN_VALUE;
        public static final Usage UNKNOWN = new Usage(Integer.MIN_VALUE, Integer.MIN_VALUE);
        private final int max;
        private final int remaining;
        private final Map<String, Usage> perApplication = new HashMap<String, Usage>();

        @JsonCreator
        Usage(@JsonProperty(value="Max") int max, @JsonProperty(value="Remaining") int remaining) {
            this.max = max;
            this.remaining = remaining;
        }

        public Optional<Usage> forApplication(String application) {
            return Optional.ofNullable(this.perApplication.get(application));
        }

        public Set<String> getApplications() {
            return this.perApplication.keySet();
        }

        public int getMax() {
            return this.max;
        }

        public Map<String, Usage> getPerApplicationUsage() {
            return Collections.unmodifiableMap(this.perApplication);
        }

        public int getRemaining() {
            return this.remaining;
        }

        public boolean isUnknown() {
            return this.max == Integer.MIN_VALUE && this.remaining == Integer.MIN_VALUE;
        }

        public String toString() {
            if (this.max == Integer.MIN_VALUE && this.remaining == Integer.MIN_VALUE) {
                return "Undefined";
            }
            return "Max: " + this.max + ", Remaining: " + this.remaining + ", per application: " + this.perApplication;
        }

        @JsonAnySetter
        void addApplicationUsage(String application, Usage usage) {
            this.perApplication.put(application, usage);
        }
    }

    public static enum Operation {
        ConcurrentAsyncGetReportInstances,
        ConcurrentSyncReportRuns,
        DailyApiRequests,
        DailyAsyncApexExecutions,
        DailyBulkApiRequests,
        DailyDurableGenericStreamingApiEvents,
        DailyDurableStreamingApiEvents,
        DailyGenericStreamingApiEvents,
        DailyStreamingApiEvents,
        DailyWorkflowEmails,
        DataStorageMB,
        DurableStreamingApiConcurrentClients,
        FileStorageMB,
        HourlyAsyncReportRuns,
        HourlyDashboardRefreshes,
        HourlyDashboardResults,
        HourlyDashboardStatuses,
        HourlyODataCallout,
        HourlySyncReportRuns,
        HourlyTimeBasedWorkflow,
        MassEmail,
        PermissionSets,
        SingleEmail,
        StreamingApiConcurrentClients;

    }

    public static final class LimitsDeserializer
    extends JsonDeserializer {
        public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            Map usages = (Map)parser.readValueAs(TypeReferences.USAGES_TYPE);
            return new Limits(usages);
        }
    }
}

