/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.grpc.GrpcComponent;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcConsumer;
import org.apache.camel.component.grpc.GrpcProducer;
import org.apache.camel.component.grpc.GrpcUtils;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.SynchronousDelegateProducer;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.19.0", scheme="grpc", title="gRPC", syntax="grpc:host:port/service", category={Category.RPC})
public class GrpcEndpoint
extends DefaultEndpoint {
    @UriParam
    protected final GrpcConfiguration configuration;
    private String serviceName;
    private String servicePackage;

    public GrpcEndpoint(String uri, GrpcComponent component, GrpcConfiguration config) throws Exception {
        super(uri, (Component)component);
        this.configuration = config;
    }

    public GrpcConfiguration getConfiguration() {
        return this.configuration;
    }

    public Producer createProducer() throws Exception {
        GrpcProducer producer = new GrpcProducer(this, this.configuration);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)producer);
        }
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        GrpcConsumer consumer = new GrpcConsumer(this, processor, this.configuration);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.serviceName = GrpcUtils.extractServiceName(this.configuration.getService());
        this.servicePackage = GrpcUtils.extractServicePackage(this.configuration.getService());
        if (!ObjectHelper.isEmpty((Object)this.configuration.getMethod())) {
            this.configuration.setMethod(GrpcUtils.convertMethod2CamelCase(this.configuration.getMethod()));
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServicePackage() {
        return this.servicePackage;
    }
}

