/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jclouds.JcloudsBlobStoreEndpoint;
import org.apache.camel.component.jclouds.JcloudsCommand;
import org.apache.camel.component.jclouds.JcloudsComputeEndpoint;
import org.apache.camel.component.jclouds.JcloudsConfiguration;
import org.apache.camel.component.jclouds.JcloudsEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.jclouds.Context;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.compute.ComputeService;

@Component(value="jclouds")
public class JcloudsComponent
extends DefaultComponent {
    private List<BlobStore> blobStores;
    private List<ComputeService> computeServices;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] uriParts = remaining.split(":");
        if (uriParts.length != 2) {
            throw new IllegalArgumentException("Invalid Endpoint URI: " + uri + ". It should contains a valid command and providerId");
        }
        String endpointType = uriParts[0];
        String providerId = uriParts[1];
        JcloudsCommand command = JcloudsCommand.valueOf(endpointType);
        JcloudsConfiguration configuration = new JcloudsConfiguration();
        configuration.setCommand(command);
        configuration.setProviderId(providerId);
        JcloudsEndpoint endpoint = JcloudsCommand.blobstore == command ? new JcloudsBlobStoreEndpoint(uri, this, this.getBlobStore(providerId)) : new JcloudsComputeEndpoint(uri, this, this.getComputeService(providerId));
        endpoint.setConfiguration(configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected BlobStore getBlobStore(String predicate) throws IllegalArgumentException {
        if (this.blobStores != null && !this.blobStores.isEmpty()) {
            if (this.isNameSupportedByContext()) {
                for (BlobStore blobStore : this.blobStores) {
                    if (!blobStore.getContext().unwrap().getName().equals(predicate)) continue;
                    return blobStore;
                }
            }
            for (BlobStore blobStore : this.blobStores) {
                if (!blobStore.getContext().unwrap().getId().equals(predicate)) continue;
                return blobStore;
            }
            throw new IllegalArgumentException(String.format("No blobstore found for:%s", predicate));
        }
        throw new IllegalArgumentException("No blobstore available.");
    }

    protected ComputeService getComputeService(String predicate) throws IllegalArgumentException {
        if (this.computeServices != null && !this.computeServices.isEmpty()) {
            if (this.isNameSupportedByContext()) {
                for (ComputeService computeService : this.computeServices) {
                    if (!computeService.getContext().unwrap().getName().equals(predicate)) continue;
                    return computeService;
                }
            }
            for (ComputeService computeService : this.computeServices) {
                if (!computeService.getContext().unwrap().getId().equals(predicate)) continue;
                return computeService;
            }
            throw new IllegalArgumentException(String.format("No compute service found for :%s", predicate));
        }
        throw new IllegalArgumentException("No compute service available.");
    }

    private boolean isNameSupportedByContext() {
        try {
            Context.class.getMethod("getName", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public List<BlobStore> getBlobStores() {
        return this.blobStores;
    }

    public void setBlobStores(List<BlobStore> blobStores) {
        this.blobStores = blobStores;
    }

    public List<ComputeService> getComputeServices() {
        return this.computeServices;
    }

    public void setComputeServices(List<ComputeService> computeServices) {
        this.computeServices = computeServices;
    }
}

