/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.olingo2.Olingo2Configuration;
import org.apache.camel.component.olingo2.Olingo2Endpoint;
import org.apache.camel.component.olingo2.Olingo2Index;
import org.apache.camel.component.olingo2.api.Olingo2ResponseHandler;
import org.apache.camel.component.olingo2.internal.Olingo2ApiName;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.component.AbstractApiConsumer;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiConsumerHelper;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;

public class Olingo2Consumer
extends AbstractApiConsumer<Olingo2ApiName, Olingo2Configuration> {
    private Olingo2Index resultIndex;

    public Olingo2Consumer(Olingo2Endpoint endpoint, Processor processor) {
        super((AbstractApiEndpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.putAll(this.endpoint.getEndpointProperties());
        this.endpoint.interceptProperties(args);
        this.interceptProperties(args);
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final Object[] result = new Object[1];
            final Exception[] error = new Exception[1];
            args.put("responseHandler", new Olingo2ResponseHandler<Object>(){

                public void onResponse(Object response, Map<String, String> responseHeaders) {
                    if (Olingo2Consumer.this.resultIndex != null) {
                        response = Olingo2Consumer.this.resultIndex.filterResponse(response);
                    }
                    result[0] = response;
                    latch.countDown();
                }

                public void onException(Exception ex) {
                    error[0] = ex;
                    latch.countDown();
                }

                public void onCanceled() {
                    error[0] = new RuntimeCamelException("OData HTTP Request cancelled");
                    latch.countDown();
                }
            });
            this.doInvokeMethod(args);
            latch.await();
            if (error[0] != null) {
                throw error[0];
            }
            if (result[0] == null || result[0] instanceof ODataFeed && ((ODataFeed)result[0]).getEntries().isEmpty()) {
                return 0;
            }
            int processed = ApiConsumerHelper.getResultsProcessed((DefaultConsumer)this, (Object)result[0], (boolean)this.isSplitResult());
            return processed;
        }
        catch (Throwable t) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)t);
        }
    }

    public void interceptProperties(Map<String, Object> properties) {
        Object value = properties.get("filterAlreadySeen");
        if (value == null) {
            return;
        }
        if (Boolean.parseBoolean(value.toString()) && this.resultIndex == null) {
            this.resultIndex = new Olingo2Index();
        }
    }

    public void interceptResult(Object result, Exchange resultExchange) {
        if (this.resultIndex == null) {
            return;
        }
        this.resultIndex.index(result);
    }

    public Object splitResult(Object result) {
        ArrayList<Object> splitResult = new ArrayList<Object>();
        if (result instanceof ODataFeed) {
            ODataFeed odataFeed = (ODataFeed)result;
            for (ODataEntry entry : odataFeed.getEntries()) {
                splitResult.add(entry);
            }
        } else {
            if (result instanceof List) {
                return result;
            }
            splitResult.add(result);
        }
        return splitResult;
    }
}

