/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.processor;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.component.crypto.processor.DigitalSignatureProcessor;
import org.apache.commons.codec.binary.Base64;

public class SigningProcessor
extends DigitalSignatureProcessor {
    public SigningProcessor(DigitalSignatureConfiguration configuration) {
        super(configuration);
    }

    public void process(Exchange exchange) throws Exception {
        Signature service = this.initSignatureService(exchange);
        this.calculateSignature(exchange, service);
        byte[] signature = service.sign();
        Message in = exchange.getIn();
        this.clearMessageHeaders(in);
        Message out = exchange.getOut();
        out.copyFrom(in);
        out.setHeader(this.config.getSignatureHeaderName(), (Object)new Base64().encode(signature));
    }

    protected Signature initSignatureService(Exchange exchange) throws Exception {
        PrivateKey pk = this.getPrivateKeyFromKeystoreOrExchange(exchange);
        SecureRandom random = this.config.getSecureRandom();
        Signature service = this.createSignatureService();
        if (random != null) {
            service.initSign(pk, random);
        } else {
            service.initSign(pk);
        }
        return service;
    }

    private PrivateKey getPrivateKeyFromKeystoreOrExchange(Exchange exchange) throws Exception {
        PrivateKey pk = this.config.getPrivateKey(this.getAlias(exchange), this.getKeyPassword(exchange));
        if (pk == null && (pk = (PrivateKey)exchange.getIn().getHeader("CamelSignaturePrivateKey", PrivateKey.class)) == null) {
            throw new IllegalStateException(String.format("Cannot sign message as no Private Key has been supplied. Either supply one in the route definition sign(keystore, alias) or sign(privateKey) or via the message header '%s'", "CamelSignaturePrivateKey"));
        }
        return pk;
    }

    protected char[] getKeyPassword(Exchange exchange) throws Exception {
        KeyStore keystore = this.config.getKeystore();
        char[] password = null;
        if (keystore != null && (password = (char[])exchange.getIn().getHeader("CamelSignatureKeyStorePassword", char[].class)) == null) {
            password = this.config.getPassword() != null ? this.config.getPassword().toCharArray() : null;
        }
        return password;
    }
}

