/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics.event.notifier.context;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsConstants;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsHelper;
import org.apache.camel.component.microprofile.metrics.event.notifier.AbstractMicroProfileMetricsEventNotifier;
import org.apache.camel.component.microprofile.metrics.event.notifier.context.MicroProfileMetricsCamelContextEventNotifierNamingStrategy;
import org.apache.camel.component.microprofile.metrics.gauge.LambdaGauge;
import org.apache.camel.spi.CamelEvent;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public class MicroProfileMetricsCamelContextEventNotifier
extends AbstractMicroProfileMetricsEventNotifier<CamelEvent.CamelContextStartingEvent> {
    private MicroProfileMetricsCamelContextEventNotifierNamingStrategy namingStrategy = MicroProfileMetricsCamelContextEventNotifierNamingStrategy.DEFAULT;

    public MicroProfileMetricsCamelContextEventNotifier() {
        super(CamelEvent.CamelContextStartingEvent.class);
    }

    public MicroProfileMetricsCamelContextEventNotifierNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicroProfileMetricsCamelContextEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void notify(CamelEvent event) throws Exception {
        if (event instanceof CamelEvent.CamelContextStartingEvent) {
            this.registerCamelContextMetrics(((CamelEvent.CamelContextStartingEvent)event).getContext());
        }
    }

    public void registerCamelContextMetrics(CamelContext camelContext) {
        MetricRegistry metricRegistry = this.getMetricRegistry();
        Tag[] tags = this.namingStrategy.getTags(camelContext);
        Metadata uptimeMetadata = new MetadataBuilder().withName(this.namingStrategy.getCamelContextUptimeName()).withDisplayName("Camel Context uptime").withDescription("The amount of time since the Camel Context was started.").withType(MetricType.GAUGE).withUnit("milliseconds").build();
        metricRegistry.register(uptimeMetadata, (Metric)new LambdaGauge(() -> camelContext.getUptimeMillis()), tags);
        Metadata statusMetadata = new MetadataBuilder().withName(this.namingStrategy.getCamelContextStatusName()).withDisplayName("Camel Context status").withDescription(MicroProfileMetricsConstants.CAMEL_CONTEXT_STATUS_DESCRIPTION).withType(MetricType.GAUGE).build();
        metricRegistry.register(statusMetadata, (Metric)new LambdaGauge(() -> camelContext.getStatus().ordinal()), tags);
    }

    protected void doStop() throws Exception {
        super.doStop();
        MicroProfileMetricsHelper.removeMetricsFromRegistry(this.getMetricRegistry(), (metricID, metric) -> {
            String name = metricID.getName();
            Map tags = metricID.getTags();
            if ((name.equals(this.namingStrategy.getCamelContextStatusName()) || name.equals(this.namingStrategy.getCamelContextUptimeName())) && tags.containsKey("camelContext")) {
                return ((String)tags.get("camelContext")).equals(this.getCamelContext().getName());
            }
            return false;
        });
    }
}

