/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.util.List;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.microprofile.metrics.AbstractMicroProfileMetricsProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsEndpoint;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsHelper;
import org.apache.camel.component.microprofile.metrics.gauge.SimpleGauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class MicroProfileMetricsGaugeProducer
extends AbstractMicroProfileMetricsProducer<SimpleGauge> {
    public MicroProfileMetricsGaugeProducer(MicroProfileMetricsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, MicroProfileMetricsEndpoint endpoint, SimpleGauge gauge) {
        Message in = exchange.getIn();
        Number finalGaugeValue = this.getNumericHeader(in, "CamelMicroProfileMetricsGaugeValue", endpoint.getGaugeValue());
        if (finalGaugeValue != null) {
            gauge.setValue(finalGaugeValue);
        }
    }

    @Override
    protected Function<MetricRegistry, SimpleGauge> registerMetric(Metadata metadata, List<Tag> tags) {
        return metricRegistry -> {
            Tag[] tagArray = tags.toArray(new Tag[0]);
            SimpleGauge existing = MicroProfileMetricsHelper.findMetric(metricRegistry, metadata.getName(), SimpleGauge.class, tags);
            if (existing == null) {
                return (SimpleGauge)metricRegistry.register(metadata, (Metric)new SimpleGauge(), tagArray);
            }
            return existing;
        };
    }
}

