/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.batch;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.sjms.batch.SessionCompletion;
import org.apache.camel.component.sjms.batch.SjmsBatchComponent;
import org.apache.camel.component.sjms.batch.SjmsBatchEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SjmsBatchConsumer
extends DefaultConsumer {
    public static final String SJMS_BATCH_TIMEOUT_CHECKER = "SJmsBatchTimeoutChecker";
    private static final boolean TRANSACTED = true;
    private static final Logger LOG = LoggerFactory.getLogger(SjmsBatchConsumer.class);
    private static final AtomicInteger BATCH_COUNT = new AtomicInteger();
    private static final AtomicLong MESSAGE_RECEIVED = new AtomicLong();
    private static final AtomicLong MESSAGE_PROCESSED = new AtomicLong();
    private ScheduledExecutorService timeoutCheckerExecutorService;
    private boolean shutdownTimeoutCheckerExecutorService;
    private final SjmsBatchEndpoint sjmsBatchEndpoint;
    private final AggregationStrategy aggregationStrategy;
    private final int completionSize;
    private final int completionInterval;
    private final int completionTimeout;
    private final Predicate completionPredicate;
    private final boolean eagerCheckCompletion;
    private final int consumerCount;
    private final int pollDuration;
    private final ConnectionFactory connectionFactory;
    private final String destinationName;
    private ExecutorService jmsConsumerExecutors;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicReference<CountDownLatch> consumersShutdownLatchRef = new AtomicReference();
    private volatile Connection connection;

    public SjmsBatchConsumer(SjmsBatchEndpoint sjmsBatchEndpoint, Processor processor) {
        super((Endpoint)sjmsBatchEndpoint, processor);
        this.sjmsBatchEndpoint = (SjmsBatchEndpoint)((Object)ObjectHelper.notNull((Object)((Object)sjmsBatchEndpoint), (String)"batchJmsEndpoint"));
        this.destinationName = StringHelper.notEmpty((String)sjmsBatchEndpoint.getDestinationName(), (String)"destinationName");
        this.completionSize = sjmsBatchEndpoint.getCompletionSize();
        this.completionInterval = sjmsBatchEndpoint.getCompletionInterval();
        this.completionTimeout = sjmsBatchEndpoint.getCompletionTimeout();
        if (this.completionInterval > 0 && this.completionTimeout != 500) {
            throw new IllegalArgumentException("Only one of completionInterval or completionTimeout can be used, not both.");
        }
        if (sjmsBatchEndpoint.isSendEmptyMessageWhenIdle() && this.completionTimeout <= 0 && this.completionInterval <= 0) {
            throw new IllegalArgumentException("SendEmptyMessageWhenIdle can only be enabled if either completionInterval or completionTimeout is also set");
        }
        this.completionPredicate = sjmsBatchEndpoint.getCompletionPredicate();
        this.eagerCheckCompletion = sjmsBatchEndpoint.isEagerCheckCompletion();
        this.pollDuration = sjmsBatchEndpoint.getPollDuration();
        if (this.pollDuration < 0) {
            throw new IllegalArgumentException("pollDuration must be 0 or greater");
        }
        this.aggregationStrategy = (AggregationStrategy)ObjectHelper.notNull((Object)sjmsBatchEndpoint.getAggregationStrategy(), (String)"aggregationStrategy");
        this.consumerCount = sjmsBatchEndpoint.getConsumerCount();
        if (this.consumerCount <= 0) {
            throw new IllegalArgumentException("consumerCount must be greater than 0");
        }
        SjmsBatchComponent sjmsBatchComponent = sjmsBatchEndpoint.getComponent();
        this.connectionFactory = (ConnectionFactory)ObjectHelper.notNull((Object)sjmsBatchComponent.getConnectionFactory(), (String)"jmsBatchComponent.connectionFactory");
    }

    public SjmsBatchEndpoint getEndpoint() {
        return this.sjmsBatchEndpoint;
    }

    public ScheduledExecutorService getTimeoutCheckerExecutorService() {
        return this.timeoutCheckerExecutorService;
    }

    public void setTimeoutCheckerExecutorService(ScheduledExecutorService timeoutCheckerExecutorService) {
        this.timeoutCheckerExecutorService = timeoutCheckerExecutorService;
    }

    protected void doStart() throws Exception {
        super.doStart();
        boolean recovery = this.getEndpoint().isAsyncStartListener();
        StartConsumerTask task = new StartConsumerTask(recovery, this.getEndpoint().getRecoveryInterval(), this.getEndpoint().getKeepAliveDelay());
        if (recovery) {
            this.getEndpoint().getComponent().getAsyncStartStopExecutorService().submit(task);
        } else {
            task.run();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.running.set(false);
        CountDownLatch consumersShutdownLatch = this.consumersShutdownLatchRef.get();
        if (consumersShutdownLatch != null) {
            LOG.info("Stop signalled, waiting on consumers to shut down");
            if (consumersShutdownLatch.await(60L, TimeUnit.SECONDS)) {
                LOG.warn("Timeout waiting on consumer threads to signal completion - shutting down");
            } else {
                LOG.info("All consumers have been shutdown");
            }
        } else {
            LOG.info("Stop signalled while there are no consumers yet, so no need to wait for consumers");
        }
        try {
            LOG.debug("Shutting down JMS connection");
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.jmsConsumerExecutors);
        this.jmsConsumerExecutors = null;
        if (this.shutdownTimeoutCheckerExecutorService) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful((ExecutorService)this.timeoutCheckerExecutorService);
            this.timeoutCheckerExecutorService = null;
        }
    }

    private class BatchConsumptionLoop
    implements Runnable {
        private final AtomicBoolean completionTimeoutTrigger = new AtomicBoolean();
        private final BatchConsumptionTask task = new BatchConsumptionTask(this.completionTimeoutTrigger);
        private int keepAliveDelay;

        private BatchConsumptionLoop() {
        }

        public AtomicBoolean getCompletionTimeoutTrigger() {
            return this.completionTimeoutTrigger;
        }

        public void setKeepAliveDelay(int i) {
            this.keepAliveDelay = i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    Session session = SjmsBatchConsumer.this.connection.createSession(true, 2);
                    try {
                        Queue queue = session.createQueue(SjmsBatchConsumer.this.destinationName);
                        MessageConsumer consumer = session.createConsumer((Destination)queue);
                        try {
                            this.task.consumeBatchesOnLoop(session, consumer);
                        }
                        finally {
                            this.closeJmsConsumer(consumer);
                        }
                    }
                    catch (IllegalStateException ex) {
                        if (this.keepAliveDelay < 0) {
                            throw ex;
                        }
                        SjmsBatchConsumer.this.getExceptionHandler().handleException("Exception caught consuming from " + SjmsBatchConsumer.this.destinationName, (Throwable)ex);
                        if (this.keepAliveDelay <= 0) continue;
                        Thread.sleep(this.keepAliveDelay);
                    }
                    finally {
                        this.closeJmsSession(session);
                    }
                } while (SjmsBatchConsumer.this.running.get() || SjmsBatchConsumer.this.isStarting());
            }
            catch (Throwable ex) {
                SjmsBatchConsumer.this.getExceptionHandler().handleException("Exception caught consuming from " + SjmsBatchConsumer.this.destinationName, ex);
            }
            finally {
                CountDownLatch consumersShutdownLatch = (CountDownLatch)SjmsBatchConsumer.this.consumersShutdownLatchRef.get();
                consumersShutdownLatch.countDown();
            }
        }

        private void closeJmsConsumer(MessageConsumer consumer) {
            try {
                consumer.close();
            }
            catch (JMSException ex2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception caught closing consumer", (Throwable)ex2);
                }
                LOG.warn("Exception caught closing consumer: {}. This exception is ignored.", (Object)ex2.getMessage());
            }
        }

        private void closeJmsSession(Session session) {
            try {
                session.close();
            }
            catch (JMSException ex2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception caught closing session", (Throwable)ex2);
                }
                LOG.warn("Exception caught closing session: {}. This exception is ignored.", (Object)ex2.getMessage());
            }
        }

        private long getReceiveWaitTime(long timeElapsed) {
            long timeRemaining = this.getTimeRemaining(timeElapsed);
            if (timeRemaining <= 0L) {
                timeRemaining = 1L;
            }
            long waitTime = Math.min(timeRemaining, (long)SjmsBatchConsumer.this.pollDuration);
            LOG.trace("Waiting for {}", (Object)waitTime);
            return waitTime;
        }

        private long getTimeRemaining(long timeElapsed) {
            long timeRemaining = (long)SjmsBatchConsumer.this.completionTimeout - timeElapsed;
            if (LOG.isDebugEnabled() && timeElapsed > 0L) {
                LOG.debug("Time remaining this batch: {}", (Object)timeRemaining);
            }
            return timeRemaining;
        }

        private void processEmptyMessage() {
            Exchange exchange = SjmsBatchConsumer.this.getEndpoint().createExchange();
            LOG.debug("Sending empty message as there were no messages from polling: {}", (Object)SjmsBatchConsumer.this.getEndpoint());
            try {
                SjmsBatchConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                SjmsBatchConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            }
        }

        private void processBatch(Exchange exchange, Session session, String completedBy) {
            int id = BATCH_COUNT.getAndIncrement();
            int batchSize = (Integer)exchange.getProperty("CamelBatchSize", Integer.class);
            if (LOG.isDebugEnabled()) {
                long total = MESSAGE_RECEIVED.get() + (long)batchSize;
                LOG.debug("Processing batch[" + id + "]:size=" + batchSize + ":total=" + total);
            }
            if ("timeout".equals(completedBy)) {
                SjmsBatchConsumer.this.aggregationStrategy.timeout(exchange, id, batchSize, (long)SjmsBatchConsumer.this.completionTimeout);
            }
            exchange.setProperty("CamelAggregatedCompletedBy", (Object)completedBy);
            SjmsBatchConsumer.this.aggregationStrategy.onCompletion(exchange);
            SessionCompletion sessionCompletion = new SessionCompletion(session);
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)sessionCompletion);
            try {
                SjmsBatchConsumer.this.getProcessor().process(exchange);
                long total = MESSAGE_PROCESSED.addAndGet(batchSize);
                LOG.debug("Completed processing[{}]:total={}", (Object)id, (Object)total);
            }
            catch (Exception e) {
                SjmsBatchConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            }
        }

        private final class BatchConsumptionTask {
            private final AtomicBoolean timeoutInterval;
            private final AtomicBoolean timeout = new AtomicBoolean();
            private int messageCount;
            private long timeElapsed;
            private long startTime;
            private Exchange aggregatedExchange;

            BatchConsumptionTask(AtomicBoolean timeoutInterval) {
                this.timeoutInterval = timeoutInterval;
            }

            private void consumeBatchesOnLoop(Session session, MessageConsumer consumer) throws JMSException {
                boolean usingTimeout = SjmsBatchConsumer.this.completionTimeout > 0;
                LOG.trace("BatchConsumptionTask +++ start +++");
                while (SjmsBatchConsumer.this.running.get()) {
                    LOG.trace("BatchConsumptionTask running");
                    if (this.timeout.compareAndSet(true, false) || this.timeoutInterval.compareAndSet(true, false)) {
                        LOG.trace("Completion batch due timeout");
                        String completedBy = SjmsBatchConsumer.this.completionInterval > 0 ? "interval" : "timeout";
                        this.completionBatch(session, completedBy);
                        this.reset();
                        continue;
                    }
                    if (SjmsBatchConsumer.this.completionSize > 0 && this.messageCount >= SjmsBatchConsumer.this.completionSize) {
                        LOG.trace("Completion batch due size");
                        this.completionBatch(session, "size");
                        this.reset();
                        continue;
                    }
                    long waitTime = usingTimeout && this.timeElapsed > 0L ? BatchConsumptionLoop.this.getReceiveWaitTime(this.timeElapsed) : (long)SjmsBatchConsumer.this.pollDuration;
                    Message message = consumer.receive(waitTime);
                    if (SjmsBatchConsumer.this.running.get()) {
                        if (message == null) {
                            LOG.trace("No message received");
                        } else {
                            ++this.messageCount;
                            LOG.debug("#{} messages received", (Object)this.messageCount);
                            if (usingTimeout && this.startTime == 0L) {
                                this.startTime = new Date().getTime();
                            }
                            Exchange exchange = SjmsBatchConsumer.this.getEndpoint().createExchange(message, session);
                            this.aggregatedExchange = SjmsBatchConsumer.this.aggregationStrategy.aggregate(this.aggregatedExchange, exchange);
                            this.aggregatedExchange.setProperty("CamelBatchSize", (Object)this.messageCount);
                            if (SjmsBatchConsumer.this.completionPredicate != null) {
                                try {
                                    boolean complete = SjmsBatchConsumer.this.eagerCheckCompletion ? SjmsBatchConsumer.this.completionPredicate.matches(exchange) : SjmsBatchConsumer.this.completionPredicate.matches(this.aggregatedExchange);
                                    if (complete) {
                                        LOG.trace("Completion batch due predicate");
                                        this.completionBatch(session, "predicate");
                                        this.reset();
                                    }
                                }
                                catch (Exception e) {
                                    LOG.warn("Error during evaluation of completion predicate " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                                }
                            }
                        }
                        if (!usingTimeout || this.startTime <= 0L) continue;
                        long currentTime = new Date().getTime();
                        this.timeElapsed = currentTime - this.startTime;
                        if (this.timeElapsed > (long)SjmsBatchConsumer.this.completionTimeout) {
                            this.timeout.set(true);
                            continue;
                        }
                        LOG.trace("This batch has more time until the timeout, elapsed: {} timeout: {}", (Object)this.timeElapsed, (Object)SjmsBatchConsumer.this.completionTimeout);
                        continue;
                    }
                    LOG.info("Shutdown signal received - rolling back batch");
                    session.rollback();
                }
                LOG.trace("BatchConsumptionTask +++ end +++");
            }

            private void reset() {
                this.messageCount = 0;
                this.timeElapsed = 0L;
                this.startTime = 0L;
                this.aggregatedExchange = null;
            }

            private void completionBatch(Session session, String completedBy) {
                if (this.aggregatedExchange == null && SjmsBatchConsumer.this.getEndpoint().isSendEmptyMessageWhenIdle()) {
                    BatchConsumptionLoop.this.processEmptyMessage();
                } else if (this.aggregatedExchange != null) {
                    BatchConsumptionLoop.this.processBatch(this.aggregatedExchange, session, completedBy);
                }
            }
        }
    }

    private final class CompletionIntervalTask
    implements Runnable {
        private final List<AtomicBoolean> triggers;

        CompletionIntervalTask(List<AtomicBoolean> triggers) {
            this.triggers = triggers;
        }

        @Override
        public void run() {
            if (!SjmsBatchConsumer.this.getEndpoint().getCamelContext().getStatus().isStarted()) {
                LOG.trace("Completion interval task cannot start due CamelContext({}) has not been started yet", (Object)SjmsBatchConsumer.this.getEndpoint().getCamelContext().getName());
                return;
            }
            for (AtomicBoolean trigger : this.triggers) {
                trigger.set(true);
            }
        }
    }

    protected class StartConsumerTask
    implements Runnable {
        private boolean recoveryEnabled;
        private int recoveryInterval;
        private int keepAliveDelay;
        private long attempt;

        public StartConsumerTask(boolean recoveryEnabled, int recoveryInterval, int keepAliveDelay) {
            this.recoveryEnabled = recoveryEnabled;
            this.recoveryInterval = recoveryInterval;
            this.keepAliveDelay = keepAliveDelay;
        }

        @Override
        public void run() {
            SjmsBatchConsumer.this.jmsConsumerExecutors = SjmsBatchConsumer.this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "SjmsBatchConsumer", SjmsBatchConsumer.this.consumerCount);
            SjmsBatchConsumer.this.consumersShutdownLatchRef.set(new CountDownLatch(SjmsBatchConsumer.this.consumerCount));
            if (SjmsBatchConsumer.this.completionInterval > 0) {
                LOG.info("Using CompletionInterval to run every {} millis.", (Object)SjmsBatchConsumer.this.completionInterval);
                if (SjmsBatchConsumer.this.timeoutCheckerExecutorService == null) {
                    SjmsBatchConsumer.this.setTimeoutCheckerExecutorService(SjmsBatchConsumer.this.getEndpoint().getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this, SjmsBatchConsumer.SJMS_BATCH_TIMEOUT_CHECKER, 1));
                    SjmsBatchConsumer.this.shutdownTimeoutCheckerExecutorService = true;
                }
            }
            while (SjmsBatchConsumer.this.isRunAllowed() && !SjmsBatchConsumer.this.running.get()) {
                Connection localConnection = null;
                try {
                    ++this.attempt;
                    LOG.debug("Attempt #{}. Starting {} consumer(s) for {}:{}", new Object[]{this.attempt, SjmsBatchConsumer.this.consumerCount, SjmsBatchConsumer.this.destinationName, SjmsBatchConsumer.this.completionSize});
                    localConnection = SjmsBatchConsumer.this.connectionFactory.createConnection();
                    localConnection.start();
                    SjmsBatchConsumer.this.connection = localConnection;
                    ArrayList<AtomicBoolean> triggers = new ArrayList<AtomicBoolean>();
                    for (int i = 0; i < SjmsBatchConsumer.this.consumerCount; ++i) {
                        BatchConsumptionLoop loop = new BatchConsumptionLoop();
                        loop.setKeepAliveDelay(this.keepAliveDelay);
                        triggers.add(loop.getCompletionTimeoutTrigger());
                        SjmsBatchConsumer.this.jmsConsumerExecutors.submit(loop);
                    }
                    if (SjmsBatchConsumer.this.completionInterval > 0) {
                        SjmsBatchConsumer.this.timeoutCheckerExecutorService.scheduleAtFixedRate(new CompletionIntervalTask(triggers), SjmsBatchConsumer.this.completionInterval, SjmsBatchConsumer.this.completionInterval, TimeUnit.MILLISECONDS);
                    }
                    if (this.attempt > 1L) {
                        LOG.info("Successfully refreshed connection after {} attempts.", (Object)this.attempt);
                    }
                    LOG.info("Started {} consumer(s) for {}:{}", new Object[]{SjmsBatchConsumer.this.consumerCount, SjmsBatchConsumer.this.destinationName, SjmsBatchConsumer.this.completionSize});
                    SjmsBatchConsumer.this.running.set(true);
                    return;
                }
                catch (Throwable e) {
                    try {
                        if (localConnection != null) {
                            localConnection.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!this.recoveryEnabled) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                    SjmsBatchConsumer.this.getExceptionHandler().handleException("Error starting consumer after " + this.attempt + " attempts. Will try again in " + this.recoveryInterval + " millis.", e);
                    try {
                        LOG.debug("Attempt #{}. Sleeping {} before next attempt to recover", (Object)this.attempt, (Object)this.recoveryInterval);
                        Thread.sleep(this.recoveryInterval);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
    }
}

