/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.sjms.AggregatedExceptionListener;
import org.apache.camel.component.sjms.MessageConsumerResources;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.consumer.AbstractMessageHandler;
import org.apache.camel.component.sjms.consumer.InOnlyMessageHandler;
import org.apache.camel.component.sjms.consumer.InOutMessageHandler;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.taskmanager.TimedTaskManager;
import org.apache.camel.component.sjms.tx.BatchTransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.DefaultTransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.SessionBatchTransactionSynchronization;
import org.apache.camel.component.sjms.tx.SessionTransactionSynchronization;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.backoff.BackOff;
import org.apache.camel.util.backoff.BackOffTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SjmsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(SjmsConsumer.class);
    private final Map<Connection, List<MessageConsumerResources>> consumers = new WeakHashMap<Connection, List<MessageConsumerResources>>();
    private ScheduledExecutorService scheduler;
    private Future<?> asyncStart;
    private BackOffTimer.Task rescheduleTask;

    public SjmsConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public SjmsEndpoint getEndpoint() {
        return (SjmsEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.scheduler = this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultScheduledThreadPool((Object)this, "SjmsConsumer");
        if (this.getEndpoint().isAsyncStartListener()) {
            this.asyncStart = this.getEndpoint().getComponent().getAsyncStartStopExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            SjmsConsumer.this.fillConsumersPool();
                        }
                        catch (Throwable e) {
                            LOG.warn("Error starting listener container on destination: " + SjmsConsumer.this.getDestinationName() + ". This exception will be ignored.", e);
                            if (!SjmsConsumer.this.getEndpoint().isReconnectOnError()) break block2;
                            SjmsConsumer.this.scheduleRefill();
                        }
                    }
                }

                public String toString() {
                    return "AsyncStartListenerTask[" + SjmsConsumer.this.getDestinationName() + "]";
                }
            });
        } else {
            this.fillConsumersPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillConsumersPool() throws Exception {
        Map<Connection, List<MessageConsumerResources>> map = this.consumers;
        synchronized (map) {
            while (this.consumers.values().stream().collect(Collectors.summarizingInt(List::size)).getSum() < (long)this.getConsumerCount()) {
                this.addConsumer();
            }
        }
    }

    public void destroyObject(MessageConsumerResources model) {
        block6: {
            try {
                if (model.getMessageConsumer() != null) {
                    model.getMessageConsumer().close();
                }
                if (model.getSession() == null) break block6;
                if (model.getSession().getTransacted()) {
                    try {
                        model.getSession().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                model.getSession().close();
            }
            catch (JMSException ex) {
                LOG.warn("Exception caught on closing consumer", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        if (this.asyncStart != null && !this.asyncStart.isDone()) {
            this.asyncStart.cancel(true);
        }
        if (this.rescheduleTask != null) {
            this.rescheduleTask.cancel();
        }
        if (this.getEndpoint().isAsyncStopListener()) {
            this.getEndpoint().getComponent().getAsyncStartStopExecutorService().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Map map = SjmsConsumer.this.consumers;
                        synchronized (map) {
                            SjmsConsumer.this.consumers.values().stream().flatMap(Collection::stream).forEach(SjmsConsumer.this::destroyObject);
                            SjmsConsumer.this.consumers.clear();
                        }
                    }
                    catch (Throwable e) {
                        LOG.warn("Error stopping listener container on destination: " + SjmsConsumer.this.getDestinationName() + ". This exception will be ignored.", e);
                    }
                }

                public String toString() {
                    return "AsyncStopListenerTask[" + SjmsConsumer.this.getDestinationName() + "]";
                }
            });
        } else {
            Map<Connection, List<MessageConsumerResources>> map = this.consumers;
            synchronized (map) {
                this.consumers.values().stream().flatMap(Collection::stream).forEach(this::destroyObject);
                this.consumers.clear();
            }
        }
        if (this.scheduler != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful((ExecutorService)this.scheduler);
        }
    }

    private void addConsumer() throws Exception {
        ConnectionResource connectionResource = this.getOrCreateConnectionResource();
        Connection conn = connectionResource.borrowConnection();
        try {
            Session session = conn.createSession(this.isTransacted(), this.isTransacted() ? 0 : 1);
            MessageConsumer messageConsumer = this.getEndpoint().getJmsObjectFactory().createMessageConsumer(session, (Endpoint)this.getEndpoint());
            MessageListener handler = this.createMessageHandler(session);
            messageConsumer.setMessageListener(handler);
            if (this.getEndpoint().isReconnectOnError()) {
                Object exceptionListener = conn.getExceptionListener();
                ReconnectExceptionListener reconnectExceptionListener = new ReconnectExceptionListener(conn);
                exceptionListener = exceptionListener == null ? reconnectExceptionListener : new AggregatedExceptionListener(new ExceptionListener[]{exceptionListener, reconnectExceptionListener});
                conn.setExceptionListener(exceptionListener);
            }
            MessageConsumerResources answer = new MessageConsumerResources(session, messageConsumer);
            this.consumers.compute(conn, (key, oldValue) -> {
                if (oldValue == null) {
                    oldValue = new ArrayList<MessageConsumerResources>();
                }
                oldValue.add(answer);
                return oldValue;
            });
        }
        catch (Exception e) {
            LOG.error("Unable to create the MessageConsumer", (Throwable)e);
            throw e;
        }
        finally {
            connectionResource.returnConnection(conn);
        }
    }

    protected MessageListener createMessageHandler(Session session) {
        Object synchronization;
        TransactionCommitStrategy commitStrategy = this.getTransactionCommitStrategy() != null ? this.getTransactionCommitStrategy() : (this.getTransactionBatchCount() > 0 ? new BatchTransactionCommitStrategy(this.getTransactionBatchCount()) : new DefaultTransactionCommitStrategy());
        if (commitStrategy instanceof BatchTransactionCommitStrategy) {
            TimedTaskManager timedTaskManager = this.getEndpoint().getComponent().getTimedTaskManager();
            synchronization = new SessionBatchTransactionSynchronization(timedTaskManager, session, commitStrategy, this.getTransactionBatchTimeout());
        } else {
            synchronization = new SessionTransactionSynchronization(session, commitStrategy);
        }
        AbstractMessageHandler messageHandler = this.getEndpoint().getExchangePattern().equals((Object)ExchangePattern.InOnly) ? (this.isTransacted() || this.isSynchronous() ? new InOnlyMessageHandler(this.getEndpoint(), this.scheduler, (Synchronization)synchronization) : new InOnlyMessageHandler(this.getEndpoint(), this.scheduler)) : (this.isTransacted() || this.isSynchronous() ? new InOutMessageHandler(this.getEndpoint(), this.scheduler, (Synchronization)synchronization) : new InOutMessageHandler(this.getEndpoint(), this.scheduler));
        messageHandler.setSession(session);
        messageHandler.setProcessor(this.getAsyncProcessor());
        messageHandler.setSynchronous(this.isSynchronous());
        messageHandler.setTransacted(this.isTransacted());
        messageHandler.setSharedJMSSession(this.isSharedJMSSession());
        messageHandler.setTopic(this.isTopic());
        return messageHandler;
    }

    @Deprecated
    protected ConnectionResource getConnectionResource() {
        return this.getEndpoint().getConnectionResource();
    }

    protected ConnectionResource getOrCreateConnectionResource() {
        ConnectionResource answer = this.getEndpoint().getConnectionResource();
        if (answer == null) {
            answer = this.getEndpoint().createConnectionResource((Object)this);
        }
        return answer;
    }

    public int getAcknowledgementMode() {
        return this.getEndpoint().getAcknowledgementMode().intValue();
    }

    public boolean isTransacted() {
        return this.getEndpoint().isTransacted();
    }

    public boolean isSharedJMSSession() {
        return this.getEndpoint().isSharedJMSSession();
    }

    public boolean isSynchronous() {
        return this.getEndpoint().isSynchronous();
    }

    public String getDestinationName() {
        return this.getEndpoint().getDestinationName();
    }

    public int getConsumerCount() {
        return this.getEndpoint().getConsumerCount();
    }

    public boolean isTopic() {
        return this.getEndpoint().isTopic();
    }

    public String getMessageSelector() {
        return this.getEndpoint().getMessageSelector();
    }

    public String getDurableSubscriptionId() {
        return this.getEndpoint().getDurableSubscriptionId();
    }

    public TransactionCommitStrategy getTransactionCommitStrategy() {
        return this.getEndpoint().getTransactionCommitStrategy();
    }

    public int getTransactionBatchCount() {
        return this.getEndpoint().getTransactionBatchCount();
    }

    public long getTransactionBatchTimeout() {
        return this.getEndpoint().getTransactionBatchTimeout();
    }

    private boolean refillPool(BackOffTimer.Task task) {
        LOG.debug("Refill consumers pool task running");
        try {
            this.fillConsumersPool();
            LOG.info("Refill consumers pool completed (attempt: {})", (Object)task.getCurrentAttempts());
            return false;
        }
        catch (Exception ex) {
            LOG.warn("Refill consumers pool failed (attempt: {}) due to: {}. Will try again in {} millis. (stacktrace in DEBUG level)", new Object[]{task.getCurrentAttempts(), ex.getMessage(), task.getCurrentDelay()});
            if (LOG.isDebugEnabled()) {
                LOG.debug("Refill consumers pool failed", (Throwable)ex);
            }
            return true;
        }
    }

    private void scheduleRefill() {
        if (this.rescheduleTask == null || this.rescheduleTask.getStatus() != BackOffTimer.Task.Status.Active) {
            BackOff backOff = BackOff.builder().delay(this.getEndpoint().getReconnectBackOff()).build();
            this.rescheduleTask = new BackOffTimer(this.scheduler).schedule(backOff, this::refillPool);
        }
    }

    private final class ReconnectExceptionListener
    implements ExceptionListener {
        private final WeakReference<Connection> connection;

        private ReconnectExceptionListener(Connection connection) {
            this.connection = new WeakReference<Connection>(connection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException exception) {
            LOG.debug("Handling JMSException for reconnecting", (Throwable)exception);
            Connection currentConnection = (Connection)this.connection.get();
            if (currentConnection != null) {
                Map map = SjmsConsumer.this.consumers;
                synchronized (map) {
                    List toClose = (List)SjmsConsumer.this.consumers.get(currentConnection);
                    if (toClose != null) {
                        toClose.forEach(SjmsConsumer.this::destroyObject);
                    }
                    SjmsConsumer.this.consumers.remove(currentConnection);
                }
                SjmsConsumer.this.scheduleRefill();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReconnectExceptionListener that = (ReconnectExceptionListener)o;
            return Objects.equals(this.connection.get(), that.connection.get());
        }

        public int hashCode() {
            Connection currentConnection = (Connection)this.connection.get();
            return currentConnection == null ? 0 : currentConnection.hashCode();
        }
    }
}

