/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.seda;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaConfiguration;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.DefaultExchangeHolder;

public class HazelcastSedaProducer
extends DefaultAsyncProducer {
    private final transient BlockingQueue<Object> queue;

    public HazelcastSedaProducer(HazelcastSedaEndpoint endpoint, BlockingQueue<Object> hzlq) {
        super((Endpoint)endpoint);
        this.queue = hzlq;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.checkAndStore(exchange);
        callback.done(true);
        return true;
    }

    private void checkAndStore(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        HazelcastSedaEndpoint endpoint = (HazelcastSedaEndpoint)this.getEndpoint();
        HazelcastSedaConfiguration configuration = endpoint.getConfiguration();
        Object obj = configuration.isTransferExchange() ? DefaultExchangeHolder.marshal((Exchange)exchange) : (!(body instanceof Serializable) ? exchange.getIn().getBody(byte[].class) : body);
        this.queue.add(obj);
        HazelcastComponentHelper.copyHeaders(exchange);
    }
}

