/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.weather.WeatherComponent;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(WeatherProducer.class);
    private final String query;

    public WeatherProducer(WeatherEndpoint endpoint, String query) {
        super((Endpoint)endpoint);
        this.query = query;
    }

    public WeatherEndpoint getEndpoint() {
        return (WeatherEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String q = this.query;
        String location = (String)exchange.getIn().getHeader("CamelWeatherLocation", String.class);
        if (location != null) {
            q = this.getEndpoint().getConfiguration().getQuery(location);
        }
        CloseableHttpClient httpClient = ((WeatherComponent)this.getEndpoint().getComponent()).getHttpClient();
        HttpGet method = new HttpGet(q);
        try {
            LOG.debug("Going to execute the Weather query {}", (Object)q);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new IllegalStateException("Got the invalid http status value '" + response.getStatusLine().getStatusCode() + "' as the result of the query '" + this.query + "'");
            }
            String weather = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            LOG.debug("Got back the Weather information {}", (Object)weather);
            if (ObjectHelper.isEmpty((Object)weather)) {
                throw new IllegalStateException("Got the unexpected value '" + weather + "' as the result of the query '" + q + "'");
            }
            String header = this.getEndpoint().getConfiguration().getHeaderName();
            if (header != null) {
                exchange.getIn().setHeader(header, (Object)weather);
            } else {
                exchange.getIn().setBody((Object)weather);
            }
            exchange.getIn().setHeader("CamelWeatherQuery", (Object)q);
        }
        finally {
            method.releaseConnection();
        }
    }
}

