/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.dizitart.no2.event.ChangeInfo;
import org.dizitart.no2.event.ChangeListener;
import org.dizitart.no2.event.ChangedItem;

public class NitriteConsumer
extends DefaultConsumer {
    private final NitriteEndpoint endpoint;
    private NitriteChangeListener changeListener;

    public NitriteConsumer(NitriteEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.changeListener = new NitriteChangeListener();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.getNitriteCollection().register((ChangeListener)this.changeListener);
    }

    protected void doStop() throws Exception {
        if (this.changeListener != null) {
            this.endpoint.getNitriteCollection().deregister((ChangeListener)this.changeListener);
        }
        super.doStop();
    }

    private class NitriteChangeListener
    implements ChangeListener {
        private NitriteChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(ChangeInfo changeInfo) {
            for (ChangedItem changedItem : changeInfo.getChangedItems()) {
                Exchange exchange = NitriteConsumer.this.endpoint.createExchange();
                Message message = exchange.getMessage();
                message.setHeader("CamelNitriteChangeTimestamp", (Object)changedItem.getChangeTimestamp());
                message.setHeader("CamelNitriteChangeType", (Object)changedItem.getChangeType());
                message.setBody((Object)changedItem.getDocument());
                try {
                    NitriteConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                finally {
                    if (exchange.getException() == null) continue;
                    NitriteConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        }
    }
}

