/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.mq;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.mq.AmazonMQ;
import com.amazonaws.services.mq.model.ConfigurationId;
import com.amazonaws.services.mq.model.CreateBrokerRequest;
import com.amazonaws.services.mq.model.CreateBrokerResult;
import com.amazonaws.services.mq.model.DeleteBrokerRequest;
import com.amazonaws.services.mq.model.DeleteBrokerResult;
import com.amazonaws.services.mq.model.DeploymentMode;
import com.amazonaws.services.mq.model.DescribeBrokerRequest;
import com.amazonaws.services.mq.model.DescribeBrokerResult;
import com.amazonaws.services.mq.model.EngineType;
import com.amazonaws.services.mq.model.ListBrokersRequest;
import com.amazonaws.services.mq.model.ListBrokersResult;
import com.amazonaws.services.mq.model.RebootBrokerRequest;
import com.amazonaws.services.mq.model.RebootBrokerResult;
import com.amazonaws.services.mq.model.UpdateBrokerRequest;
import com.amazonaws.services.mq.model.UpdateBrokerResult;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.mq.MQConfiguration;
import org.apache.camel.component.aws.mq.MQEndpoint;
import org.apache.camel.component.aws.mq.MQOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MQProducer.class);
    private transient String mqProducerToString;

    public MQProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listBrokers: {
                this.listBrokers(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case createBroker: {
                this.createBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case deleteBroker: {
                this.deleteBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case rebootBroker: {
                this.rebootBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case updateBroker: {
                this.updateBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case describeBroker: {
                this.describeBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private MQOperations determineOperation(Exchange exchange) {
        MQOperations operation = (MQOperations)((Object)exchange.getIn().getHeader("CamelAwsMQOperation", MQOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected MQConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.mqProducerToString == null) {
            this.mqProducerToString = "MQProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.mqProducerToString;
    }

    public MQEndpoint getEndpoint() {
        return (MQEndpoint)super.getEndpoint();
    }

    private void listBrokers(AmazonMQ mqClient, Exchange exchange) {
        ListBrokersResult result;
        ListBrokersRequest request = new ListBrokersRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQMaxResults"))) {
            int maxResults = (Integer)exchange.getIn().getHeader("CamelAwsMQMaxResults", Integer.class);
            request.withMaxResults(Integer.valueOf(maxResults));
        }
        try {
            result = mqClient.listBrokers(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("List Brokers command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MQProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createBroker(AmazonMQ mqClient, Exchange exchange) {
        CreateBrokerResult result;
        CreateBrokerRequest request = new CreateBrokerRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerName"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerName = (String)exchange.getIn().getHeader("CamelAwsMQBrokerName", String.class);
        request.withBrokerName(brokerName);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerEngine"))) {
            String brokerEngine = (String)exchange.getIn().getHeader("CamelAwsMQBrokerEngine", String.class);
            request.withEngineType(EngineType.fromValue((String)brokerEngine));
        } else {
            request.withEngineType(EngineType.ACTIVEMQ.name());
        }
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerEngineVersion"))) {
            throw new IllegalArgumentException("Broker Engine Version must be specified");
        }
        String brokerEngineVersion = (String)exchange.getIn().getHeader("CamelAwsMQBrokerEngineVersion", String.class);
        request.withEngineVersion(brokerEngineVersion);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerDeploymentMode"))) {
            throw new IllegalArgumentException("Deployment Mode must be specified");
        }
        String deploymentMode = (String)exchange.getIn().getHeader("CamelAwsMQBrokerDeploymentMode", String.class);
        request.withDeploymentMode(DeploymentMode.fromValue((String)deploymentMode));
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerInstanceType"))) {
            throw new IllegalArgumentException("Instance Type must be specified");
        }
        String instanceType = (String)exchange.getIn().getHeader("CamelAwsMQBrokerInstanceType", String.class);
        request.withHostInstanceType(instanceType);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerUsers"))) {
            throw new IllegalArgumentException("A Users list must be specified");
        }
        List users = (List)exchange.getIn().getHeader("CamelAwsMQBrokerUsers", List.class);
        request.withUsers((Collection)users);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerPubliclyAccessible"))) {
            Boolean publiclyAccessible = (Boolean)exchange.getIn().getHeader("CamelAwsMQBrokerPubliclyAccessible", Boolean.class);
            request.withPubliclyAccessible(publiclyAccessible);
        } else {
            request.withPubliclyAccessible(Boolean.valueOf(false));
        }
        try {
            result = mqClient.createBroker(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Create Broker command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MQProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteBroker(AmazonMQ mqClient, Exchange exchange) {
        DeleteBrokerResult result;
        DeleteBrokerRequest request = new DeleteBrokerRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
        request.withBrokerId(brokerId);
        try {
            result = mqClient.deleteBroker(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Delete Broker command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MQProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void rebootBroker(AmazonMQ mqClient, Exchange exchange) {
        RebootBrokerResult result;
        RebootBrokerRequest request = new RebootBrokerRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
        request.withBrokerId(brokerId);
        try {
            result = mqClient.rebootBroker(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Reboot Broker command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MQProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void updateBroker(AmazonMQ mqClient, Exchange exchange) {
        UpdateBrokerResult result;
        UpdateBrokerRequest request = new UpdateBrokerRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
        request.withBrokerId(brokerId);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQConfigurationID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        ConfigurationId configurationId = (ConfigurationId)exchange.getIn().getHeader("CamelAwsMQConfigurationID", ConfigurationId.class);
        request.withConfiguration(configurationId);
        try {
            result = mqClient.updateBroker(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Update Broker command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MQProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeBroker(AmazonMQ mqClient, Exchange exchange) {
        DescribeBrokerResult result;
        DescribeBrokerRequest request = new DescribeBrokerRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
        request.withBrokerId(brokerId);
        try {
            result = mqClient.describeBroker(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Reboot Broker command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MQProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

