/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.mq;

import com.amazonaws.Protocol;
import com.amazonaws.services.mq.AmazonMQ;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.mq.MQComponent;
import org.apache.camel.component.aws.mq.MQConfiguration;
import org.apache.camel.component.aws.mq.MQOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class MQComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private MQConfiguration getOrCreateConfiguration(MQComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new MQConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        MQComponent target = (MQComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)MQComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonmqclient": 
            case "amazonMqClient": {
                this.getOrCreateConfiguration(target).setAmazonMqClient((AmazonMQ)MQComponentConfigurer.property((CamelContext)camelContext, AmazonMQ.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)MQComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((MQConfiguration)MQComponentConfigurer.property((CamelContext)camelContext, MQConfiguration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)MQComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((MQOperations)((Object)MQComponentConfigurer.property((CamelContext)camelContext, MQOperations.class, (Object)value)));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)MQComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)MQComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)MQComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)MQComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)MQComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonMqClient", AmazonMQ.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("configuration", MQConfiguration.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("operation", MQOperations.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        MQComponent target = (MQComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonmqclient": 
            case "amazonMqClient": {
                return this.getOrCreateConfiguration(target).getAmazonMqClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
        }
        return null;
    }
}

