/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.lightcouch.Changes;
import org.lightcouch.CouchDbClient;
import org.lightcouch.CouchDbContext;
import org.lightcouch.CouchDbException;
import org.lightcouch.Response;

public class CouchDbClientWrapper {
    private final CouchDbClient client;

    public CouchDbClientWrapper(CouchDbClient client) {
        this.client = client;
    }

    public Response update(Object doc) {
        return this.client.update(doc);
    }

    public Response save(Object doc) {
        return this.client.save(doc);
    }

    public Response remove(Object doc) {
        return this.client.remove(doc);
    }

    public Changes changes() {
        return this.client.changes();
    }

    public Object get(String id) {
        return this.client.find(id);
    }

    public CouchDbContext context() {
        return this.client.context();
    }

    public String getLatestUpdateSequence() {
        HttpGet getDbInfoRequest = new HttpGet(this.client.getDBUri());
        try {
            HttpResponse getDbInfoResponse = this.client.executeRequest((HttpRequestBase)getDbInfoRequest);
            String dbInfoString = EntityUtils.toString((HttpEntity)getDbInfoResponse.getEntity());
            JsonObject dbInfo = (JsonObject)this.client.getGson().fromJson(dbInfoString, JsonObject.class);
            return dbInfo.get("update_seq").getAsString();
        }
        catch (IOException e) {
            getDbInfoRequest.abort();
            throw new CouchDbException("Error executing request to fetch the latest update sequence. ", (Throwable)e);
        }
    }
}

