/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.component.twitter.AbstractTwitterComponent;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.data.EndpointType;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultPollingEndpoint;

public abstract class AbstractTwitterEndpoint
extends DefaultPollingEndpoint
implements TwitterEndpoint {
    public static final long DEFAULT_CONSUMER_DELAY = 30000L;
    @UriParam(defaultValue="30000", javaType="java.time.Duration", label="consumer,scheduler", description="Milliseconds before the next poll.")
    private long delay = 30000L;
    @UriParam
    private TwitterConfiguration properties;

    public AbstractTwitterEndpoint(String uri, AbstractTwitterComponent component, TwitterConfiguration properties) {
        super(uri, (Component)component);
        this.setDelay(30000L);
        this.properties = properties;
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public void configureConsumer(Consumer consumer) throws Exception {
        super.configureConsumer(consumer);
    }

    @Override
    @ManagedAttribute
    public TwitterConfiguration getProperties() {
        return this.properties;
    }

    public void setProperties(TwitterConfiguration properties) {
        this.properties = properties;
    }

    @ManagedAttribute
    public String getLocations() {
        return this.getProperties().getLocations();
    }

    @ManagedAttribute
    public void setLocations(String locations) {
        this.getProperties().setLocations(locations);
    }

    @ManagedAttribute
    public void setFilterOld(boolean filterOld) {
        this.getProperties().setFilterOld(filterOld);
    }

    @ManagedAttribute
    public boolean isFilterOld() {
        return this.getProperties().isFilterOld();
    }

    @ManagedAttribute
    public void setSinceId(long sinceId) {
        this.getProperties().setSinceId(sinceId);
    }

    @ManagedAttribute
    public long getSinceId() {
        return this.getProperties().getSinceId();
    }

    @ManagedAttribute
    public void setLang(String lang) {
        this.getProperties().setLang(lang);
    }

    @ManagedAttribute
    public String getLang() {
        return this.getProperties().getLang();
    }

    @ManagedAttribute
    public void setCount(Integer count) {
        this.getProperties().setCount(count);
    }

    @ManagedAttribute
    public Integer getCount() {
        return this.getProperties().getCount();
    }

    @ManagedAttribute
    public void setNumberOfPages(Integer numberOfPages) {
        this.getProperties().setNumberOfPages(numberOfPages);
    }

    @ManagedAttribute
    public Integer getNumberOfPages() {
        return this.getProperties().getNumberOfPages();
    }

    @Override
    public EndpointType getEndpointType() {
        return this.getProperties().getType();
    }

    public void setDelay(long delay) {
        super.setDelay(delay);
        this.delay = delay;
    }
}

