/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.syslog;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.camel.Converter;
import org.apache.camel.component.syslog.Rfc5424SyslogMessage;
import org.apache.camel.component.syslog.SyslogFacility;
import org.apache.camel.component.syslog.SyslogMessage;
import org.apache.camel.component.syslog.SyslogSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public final class SyslogConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogConverter.class);
    private static Map<String, MONTHS> monthValueMap = new HashMap<String, MONTHS>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("jan", MONTHS.jan);
            this.put("feb", MONTHS.feb);
            this.put("mar", MONTHS.mar);
            this.put("apr", MONTHS.apr);
            this.put("may", MONTHS.may);
            this.put("jun", MONTHS.jun);
            this.put("jul", MONTHS.jul);
            this.put("aug", MONTHS.aug);
            this.put("sep", MONTHS.sep);
            this.put("oct", MONTHS.oct);
            this.put("nov", MONTHS.nov);
            this.put("dec", MONTHS.dec);
        }
    };

    private SyslogConverter() {
    }

    @Converter
    public static String toString(SyslogMessage message) {
        boolean isRfc5424 = message instanceof Rfc5424SyslogMessage;
        StringBuilder sbr = new StringBuilder();
        sbr.append("<");
        if (message.getFacility() == null) {
            message.setFacility(SyslogFacility.USER);
        }
        if (message.getSeverity() == null) {
            message.setSeverity(SyslogSeverity.INFO);
        }
        if (message.getHostname() == null) {
            try {
                message.setHostname(InetAddress.getLocalHost().toString());
            }
            catch (UnknownHostException e) {
                message.setHostname("UNKNOWN_HOST");
            }
        }
        sbr.append(message.getFacility().ordinal() * 8 + message.getSeverity().ordinal());
        sbr.append(">");
        if (isRfc5424) {
            sbr.append("1");
            sbr.append(" ");
        }
        if (message.getTimestamp() == null) {
            message.setTimestamp(Calendar.getInstance());
        }
        if (isRfc5424) {
            sbr.append(DatatypeConverter.printDateTime((Calendar)message.getTimestamp()));
        } else {
            SyslogConverter.addRfc3164TimeStamp(sbr, message);
        }
        sbr.append(" ");
        sbr.append(message.getHostname());
        sbr.append(" ");
        if (isRfc5424) {
            Rfc5424SyslogMessage rfc5424SyslogMessage = (Rfc5424SyslogMessage)message;
            sbr.append(rfc5424SyslogMessage.getAppName());
            sbr.append(" ");
            sbr.append(rfc5424SyslogMessage.getProcId());
            sbr.append(" ");
            sbr.append(rfc5424SyslogMessage.getMsgId());
            sbr.append(" ");
            sbr.append(rfc5424SyslogMessage.getStructuredData());
            sbr.append(" ");
        }
        sbr.append(message.getLogMessage());
        return sbr.toString();
    }

    @Converter
    public static SyslogMessage toSyslogMessage(String body) {
        return SyslogConverter.parseMessage(body.getBytes());
    }

    public static SyslogMessage parseMessage(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.put(bytes);
        byteBuffer.rewind();
        Character charFound = Character.valueOf((char)byteBuffer.get());
        SyslogFacility foundFacility = null;
        SyslogSeverity foundSeverity = null;
        while (charFound.charValue() != '<') {
            charFound = Character.valueOf((char)byteBuffer.get());
        }
        char priChar = '\u0000';
        if (charFound.charValue() == '<') {
            int facility = 0;
            while (true) {
                char c = (char)(byteBuffer.get() & 0xFF);
                priChar = c;
                if (!Character.isDigit(c)) break;
                facility *= 10;
                facility += Character.digit(priChar, 10);
            }
            foundFacility = SyslogFacility.values()[facility >> 3];
            foundSeverity = SyslogSeverity.values()[facility & 7];
        }
        if (priChar != '>') {
            LOG.error("Invalid syslog message, missing a > in the Facility/Priority part");
        }
        SyslogMessage syslogMessage = new SyslogMessage();
        boolean isRfc5424 = false;
        charFound = Character.valueOf((char)byteBuffer.get());
        if (charFound.charValue() == '1') {
            syslogMessage = new Rfc5424SyslogMessage();
            isRfc5424 = true;
        } else {
            byteBuffer.position(byteBuffer.position() - 1);
        }
        syslogMessage.setFacility(foundFacility);
        syslogMessage.setSeverity(foundSeverity);
        if (!isRfc5424) {
            syslogMessage.setTimestamp(SyslogConverter.parseRfc3164Date(byteBuffer));
        } else {
            charFound = Character.valueOf((char)byteBuffer.get());
            if (charFound.charValue() != ' ') {
                LOG.error("Invalid syslog message, missing a mandatory space after version");
            }
            StringBuilder date = new StringBuilder();
            while ((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue() != ' ') {
                date.append(charFound);
            }
            syslogMessage.setTimestamp(DatatypeConverter.parseDateTime((String)date.toString()));
        }
        StringBuilder host = new StringBuilder();
        while ((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue() != ' ') {
            host.append(charFound);
        }
        syslogMessage.setHostname(host.toString());
        if (isRfc5424) {
            Rfc5424SyslogMessage rfc5424SyslogMessage = (Rfc5424SyslogMessage)syslogMessage;
            StringBuilder appName = new StringBuilder();
            while ((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue() != ' ') {
                appName.append(charFound);
            }
            rfc5424SyslogMessage.setAppName(appName.toString());
            StringBuilder procId = new StringBuilder();
            while ((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue() != ' ') {
                procId.append(charFound);
            }
            rfc5424SyslogMessage.setProcId(procId.toString());
            StringBuilder msgId = new StringBuilder();
            while ((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue() != ' ') {
                msgId.append(charFound);
            }
            rfc5424SyslogMessage.setMsgId(msgId.toString());
            StringBuilder structuredData = new StringBuilder();
            boolean inblock = false;
            while ((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue() != ' ' || inblock) {
                if (charFound.charValue() == '[') {
                    inblock = true;
                }
                if (charFound.charValue() == ']') {
                    inblock = false;
                }
                structuredData.append(charFound);
            }
            rfc5424SyslogMessage.setStructuredData(structuredData.toString());
        }
        StringBuilder msg = new StringBuilder();
        while (byteBuffer.hasRemaining()) {
            charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF));
            msg.append(charFound);
        }
        syslogMessage.setLogMessage(msg.toString());
        LOG.trace("Syslog message : {}", (Object)syslogMessage);
        return syslogMessage;
    }

    private static void addRfc3164TimeStamp(StringBuilder sbr, SyslogMessage message) {
        Calendar cal = message.getTimestamp();
        String firstLetter = MONTHS.values()[cal.get(2)].toString().substring(0, 1);
        String remainder = MONTHS.values()[cal.get(2)].toString().substring(1);
        String capitalized = firstLetter.toUpperCase() + remainder.toLowerCase();
        sbr.append(capitalized);
        sbr.append(" ");
        if (cal.get(5) < 10) {
            sbr.append(" ").append(cal.get(5));
        } else {
            sbr.append(cal.get(5));
        }
        sbr.append(" ");
        if (cal.get(11) < 10) {
            sbr.append("0").append(cal.get(11));
        } else {
            sbr.append(cal.get(11));
        }
        sbr.append(":");
        if (cal.get(12) < 10) {
            sbr.append("0").append(cal.get(12));
        } else {
            sbr.append(cal.get(12));
        }
        sbr.append(":");
        if (cal.get(13) < 10) {
            sbr.append("0").append(cal.get(13));
        } else {
            sbr.append(cal.get(13));
        }
    }

    private static Calendar parseRfc3164Date(ByteBuffer byteBuffer) {
        char[] month = new char[3];
        for (int i = 0; i < 3; ++i) {
            month[i] = (char)(byteBuffer.get() & 0xFF);
        }
        char charFound = (char)byteBuffer.get();
        if (charFound != ' ') {
            LOG.error("Invalid syslog message, missing a mandatory space after month");
        }
        charFound = (char)(byteBuffer.get() & 0xFF);
        int day = 0;
        if (charFound != ' ') {
            day *= 10;
            day += Character.digit(charFound, 10);
        }
        while (Character.isDigit(charFound = (char)(byteBuffer.get() & 0xFF))) {
            day *= 10;
            day += Character.digit(charFound, 10);
        }
        int hour = 0;
        while (Character.isDigit(charFound = (char)(byteBuffer.get() & 0xFF))) {
            hour *= 10;
            hour += Character.digit(charFound, 10);
        }
        int minute = 0;
        while (Character.isDigit(charFound = (char)(byteBuffer.get() & 0xFF))) {
            minute *= 10;
            minute += Character.digit(charFound, 10);
        }
        int second = 0;
        while (Character.isDigit(charFound = (char)(byteBuffer.get() & 0xFF))) {
            second *= 10;
            second += Character.digit(charFound, 10);
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(2, monthValueMap.get(String.valueOf(month).toLowerCase()).ordinal());
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar;
    }

    private static enum MONTHS {
        jan,
        feb,
        mar,
        apr,
        may,
        jun,
        jul,
        aug,
        sep,
        oct,
        nov,
        dec;

    }
}

